/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist;

import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.ResidenceListPlugin;
import com.artformgames.plugin.residencelist.command.AdminCommands;
import com.artformgames.plugin.residencelist.command.UserCommands;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.conf.PluginMessages;
import com.artformgames.plugin.residencelist.hooker.PluginExpansion;
import com.artformgames.plugin.residencelist.lib.bstats.bukkit.Metrics;
import com.artformgames.plugin.residencelist.lib.easyplugin.EasyPlugin;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUI;
import com.artformgames.plugin.residencelist.lib.easyplugin.i18n.EasyPluginMessageProvider;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.MineConfiguration;
import com.artformgames.plugin.residencelist.listener.EditHandler;
import com.artformgames.plugin.residencelist.listener.ResidenceListener;
import com.artformgames.plugin.residencelist.listener.UserListener;
import com.artformgames.plugin.residencelist.storage.DataStorage;
import com.artformgames.plugin.residencelist.storage.yaml.YAMLStorage;
import com.artformgames.plugin.residencelist.ui.ResidenceListUI;
import com.artformgames.plugin.residencelist.utils.GHUpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Main
extends EasyPlugin
implements ResidenceListPlugin {
    private static Main instance;
    protected MineConfiguration configuration;
    protected DataStorage<?, ?> storage;

    public Main() {
        super(EasyPluginMessageProvider.EN_US);
        instance = this;
        ResidenceListAPI.plugin = this;
    }

    @Override
    protected void load() {
        this.log("Loading plugin configurations...");
        this.configuration = new MineConfiguration((JavaPlugin)this, PluginConfig.class, PluginMessages.class);
    }

    @Override
    protected boolean initialize() {
        if (this.storage == null) {
            this.log("Initialize data storage...");
            this.storage = new YAMLStorage(this);
        }
        this.log("Loading storage data...");
        this.storage.initialize();
        this.log("Register listeners...");
        GUI.initialize(this);
        this.registerListener(new EditHandler());
        this.registerListener(new ResidenceListener());
        this.registerListener(new UserListener());
        this.log("Register commands...");
        this.registerCommand("ResidenceList", (CommandExecutor)new UserCommands(this));
        this.registerCommand("ResidenceListAdmin", (CommandExecutor)new AdminCommands(this));
        this.log("Initializing Placeholders...");
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PluginExpansion((JavaPlugin)this, this.getName()).register();
        } else {
            this.log("PlaceholderAPI is not found, skipped.");
        }
        if (((Boolean)PluginConfig.METRICS.getNotNull()).booleanValue()) {
            this.log("Initializing bStats...");
            new Metrics((Plugin)this, 19709);
        }
        if (((Boolean)PluginConfig.CHECK_UPDATE.getNotNull()).booleanValue()) {
            this.log("Start to check the plugin versions...");
            this.getScheduler().runAsync(GHUpdateChecker.runner((Plugin)this));
        } else {
            this.log("Version checker is disabled, skipped.");
        }
        return true;
    }

    @Override
    protected void shutdown() {
        GUI.closeAll();
        this.log("Saving all data to storage...");
        this.storage.shutdown();
    }

    @Override
    public boolean isDebugging() {
        return (Boolean)PluginConfig.DEBUG.getNotNull();
    }

    public MineConfiguration getConfiguration() {
        return this.configuration;
    }

    public static void info(String ... messages) {
        Main.getInstance().log(messages);
    }

    public static void severe(String ... messages) {
        Main.getInstance().error(messages);
    }

    public static void debugging(String ... messages) {
        Main.getInstance().debug(messages);
    }

    public static Main getInstance() {
        return instance;
    }

    @Override
    public void openGUI(@NotNull Player player, @Nullable String owner) {
        ResidenceListUI.open(player, owner);
    }

    @Override
    @NotNull
    public DataStorage<?, ?> getStorage() {
        return this.storage;
    }

    @Override
    public void setStorage(DataStorage<?, ?> storage) {
        this.storage = storage;
    }
}

