/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist;

import com.artformgames.plugin.residencelist.ResidenceListPlugin;
import com.artformgames.plugin.residencelist.api.ResidenceManager;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.user.UserListData;
import com.artformgames.plugin.residencelist.lib.easyplugin.user.UserDataRegistry;
import com.artformgames.plugin.residencelist.storage.DataStorage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ResidenceListAPI {
    public static ResidenceListPlugin plugin;
    protected static DateTimeFormatter formatter;

    private ResidenceListAPI() {
    }

    public static ResidenceListPlugin plugin() {
        if (plugin == null) {
            plugin = (ResidenceListPlugin)Bukkit.getPluginManager().getPlugin("ResidenceList");
        }
        return plugin;
    }

    public static void openGUI(Player player, @Nullable String owner) {
        plugin.openGUI(player, owner);
    }

    @NotNull
    public static ResidenceData getResidenceData(@NotNull ClaimedResidence residence) {
        return ResidenceListAPI.getResidenceManager().getResidence(residence);
    }

    @Nullable
    public static ClaimedResidence getResidence(@NotNull String name) {
        return Residence.getInstance().getResidenceManager().getByName(name);
    }

    public static @Unmodifiable @NotNull Map<String, ClaimedResidence> getResidences() {
        return Collections.unmodifiableMap(Residence.getInstance().getResidenceManager().getResidences());
    }

    public static @Unmodifiable @NotNull Set<ClaimedResidence> listResidences() {
        return Set.copyOf(ResidenceListAPI.getResidences().values());
    }

    public static DataStorage<?, ?> getStorage() {
        return ResidenceListAPI.plugin().getStorage();
    }

    public void setStorage(@NotNull DataStorage<?, ?> storage) {
        ResidenceListAPI.plugin().setStorage(storage);
    }

    public static ResidenceManager<?> getResidenceManager() {
        return ResidenceListAPI.plugin().getResidenceManager();
    }

    public static UserDataRegistry<UUID, ? extends UserListData> getUserManager() {
        return ResidenceListAPI.plugin().getUserManager();
    }

    public static DateTimeFormatter getFormatter() {
        return formatter;
    }

    public static String format(@NotNull LocalDateTime time) {
        return time.format(formatter);
    }

    @Contract(value="null -> null;!null -> !null")
    public static LocalDateTime parse(@Nullable String time) {
        return time == null ? null : LocalDateTime.parse(time, formatter);
    }

    static {
        formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }
}

