/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.api;

import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface ResidenceManager<D extends ResidenceData> {
    public @Unmodifiable @NotNull Set<D> listResidences();

    @Nullable
    public D getResidence(@NotNull String var1);

    @NotNull
    default public D getResidence(@NotNull ClaimedResidence residence) {
        return (D)((ResidenceData)Objects.requireNonNull(this.getResidence(residence.getName())));
    }

    @NotNull
    public D loadResidence(String var1) throws Exception;

    public void renameResidence(String var1, String var2);

    public void removeResidence(@NotNull String var1);

    public boolean updateResidence(@NotNull ResidenceData var1, @NotNull Consumer<ResidenceData> var2);

    default public boolean updateResidence(@NotNull String name, @NotNull Consumer<ResidenceData> dataConsumer) {
        D data = this.getResidence(name);
        if (data == null) {
            return false;
        }
        return this.updateResidence((ResidenceData)data, dataConsumer);
    }

    public void saveAllResidences();
}

