/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.api.residence;

import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceRate;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface ResidenceData {
    @NotNull
    public ClaimedResidence getResidence();

    @Nullable
    public Material getIconMaterial();

    public int getCustomModelData();

    default public void setIconMaterial(@NotNull ItemStack iconItem) {
        int customModelData = -1;
        ItemMeta meta = iconItem.getItemMeta();
        if (meta != null && meta.hasCustomModelData()) {
            customModelData = meta.getCustomModelData();
        }
        this.setIconMaterial(iconItem.getType(), customModelData);
    }

    public void setIconMaterial(@NotNull Material var1, int var2);

    @NotNull
    default public String getDisplayName() {
        return Pattern.quote(Optional.ofNullable(this.getAliasName()).orElse(this.getName()));
    }

    @Nullable
    public String getAliasName();

    public void setNickname(@NotNull String var1);

    public @Unmodifiable @NotNull List<String> getDescription();

    public void setDescription(@NotNull List<String> var1);

    default public void setDescription(String ... descriptions) {
        this.setDescription(List.of(descriptions));
    }

    public boolean isPublicDisplayed();

    public void setPublicDisplayed(boolean var1);

    public Map<UUID, ResidenceRate> getRates();

    public void setRates(Map<UUID, ResidenceRate> var1);

    public void setRate(UUID var1, ResidenceRate var2);

    default public void addRate(ResidenceRate rate) {
        this.setRate(rate.author(), rate);
    }

    default public void addRate(String content, boolean recommend, UUID author, LocalDateTime time) {
        this.addRate(new ResidenceRate(author, content, recommend, time));
    }

    default public void addRate(String content, boolean recommend, UUID author) {
        this.addRate(content, recommend, author, LocalDateTime.now());
    }

    public void removeRate(UUID var1);

    default public String getName() {
        return this.getResidence().getName();
    }

    default public String getOwner() {
        return this.getResidence().getOwner();
    }

    default public boolean isOwner(@NotNull Player player) {
        return this.getResidence().isOwner(player);
    }

    @Nullable
    default public Location getTeleportLocation(Player player) {
        return this.getTeleportLocation(player, null);
    }

    @Contract(value="_,!null->!null")
    @Nullable
    default public Location getTeleportLocation(Player player, Location defaults) {
        return Optional.ofNullable(this.getResidence().getTeleportLocation(player, false)).orElse(defaults);
    }

    default public int countRate(Predicate<ResidenceRate> predicate) {
        return (int)this.getRates().values().stream().filter(predicate).count();
    }

    default public double rateRatio(Predicate<ResidenceRate> predicate) {
        return this.getRates().isEmpty() ? 0.0 : (double)this.countRate(predicate) / (double)this.getRates().size();
    }

    default public boolean canTeleport(Player player) {
        return this.isOwner(player) || this.checkPermission(player, Flags.tp, true);
    }

    default public boolean checkPermission(Player player, Flags flags, boolean defaults) {
        return this.getResidence().getPermissions().playerHas(player, flags, defaults);
    }

    public void renameTo(@NotNull File var1) throws Exception;

    public void save() throws Exception;

    default public void modify(Consumer<ResidenceData> modifier) {
        ResidenceListAPI.getResidenceManager().updateResidence(this, modifier);
    }
}

