/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.api.sort;

import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.residence.ResidenceRate;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.ColorParser;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;

public enum SortFunctions {
    NAME(SortFunctions.comparingData(data -> ColorParser.clear(data.getDisplayName()), String::compareToIgnoreCase)),
    RATINGS(SortFunctions.comparingData(d -> d.rateRatio(ResidenceRate::recommend), Double::compare).thenComparing(d -> d.countRate(ResidenceRate::recommend), Integer::compare).thenComparing(SortFunctions.NAME.comparator)),
    SIZE(SortFunctions.comparingData(d -> d.getResidence().getMainArea().getSize(), Long::compare).thenComparing(SortFunctions.NAME.comparator));

    private final Comparator<ResidenceData> comparator;

    private SortFunctions(Comparator<ResidenceData> comparator) {
        this.comparator = comparator;
    }

    public Comparator<ResidenceData> dataComparator(boolean reverse) {
        return reverse ? this.comparator.reversed() : this.comparator;
    }

    public Comparator<ClaimedResidence> residenceComparator(boolean reverse) {
        return Comparator.comparing(ResidenceListAPI::getResidenceData, this.dataComparator(reverse));
    }

    public SortFunctions next() {
        return SortFunctions.next(this);
    }

    public static <U> Comparator<ResidenceData> comparingData(Function<ResidenceData, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        return (c1, c2) -> keyComparator.compare((Object)keyExtractor.apply((ResidenceData)c1), (Object)keyExtractor.apply((ResidenceData)c2));
    }

    public static SortFunctions next(SortFunctions v) {
        return v.ordinal() >= SortFunctions.values().length - 1 ? SortFunctions.values()[0] : SortFunctions.values()[v.ordinal() + 1];
    }

    public static SortFunctions parse(int i) {
        return Arrays.stream(SortFunctions.values()).filter(v -> v.ordinal() == i).findFirst().orElse(NAME);
    }
}

