/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.command.user;

import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.command.UserCommands;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.conf.PluginMessages;
import com.artformgames.plugin.residencelist.lib.easyplugin.command.SimpleCompleter;
import com.artformgames.plugin.residencelist.lib.easyplugin.command.SubCommand;
import com.artformgames.plugin.residencelist.ui.ResidenceManageUI;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class EditCommand
extends SubCommand<UserCommands> {
    public EditCommand(@NotNull UserCommands parent, String identifier, String ... aliases) {
        super(parent, identifier, aliases);
    }

    @Override
    public Void execute(JavaPlugin plugin, CommandSender sender, String[] args) throws Exception {
        if (!(sender instanceof Player)) {
            PluginMessages.COMMAND.ONLY_PLAYER.sendTo(sender, new Object[0]);
            return null;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            return ((UserCommands)this.getParent()).noArgs(sender);
        }
        ClaimedResidence residence = ResidenceListAPI.getResidence(args[0]);
        if (residence == null) {
            PluginMessages.COMMAND.NOT_EXISTS.sendTo(sender, args[0]);
            return null;
        }
        ResidenceData data = ResidenceListAPI.getResidenceData(residence);
        if (!residence.isOwner(player)) {
            PluginMessages.COMMAND.NOT_OWNER.sendTo(sender, Pattern.quote(residence.getName()), data.getDisplayName());
            return null;
        }
        ResidenceManageUI.open(player, data, null);
        PluginConfig.GUI.OPEN_SOUND.playTo(player);
        return null;
    }

    @Override
    public List<String> tabComplete(JavaPlugin plugin, CommandSender sender, String[] args) {
        if (args.length == 1) {
            return SimpleCompleter.objects(args[args.length - 1], ResidenceListAPI.getResidences().values().stream().filter(r -> r.isOwner(sender)).map(ClaimedResidence::getName));
        }
        return SimpleCompleter.none();
    }
}

