/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.command.user;

import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.command.UserCommands;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.conf.PluginMessages;
import com.artformgames.plugin.residencelist.lib.easyplugin.command.SimpleCompleter;
import com.artformgames.plugin.residencelist.lib.easyplugin.command.SubCommand;
import com.artformgames.plugin.residencelist.ui.ResidenceInfoUI;
import com.artformgames.plugin.residencelist.utils.ResidenceUtils;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class InfoCommand
extends SubCommand<UserCommands> {
    public InfoCommand(@NotNull UserCommands parent, String identifier, String ... aliases) {
        super(parent, identifier, aliases);
    }

    @Override
    public Void execute(JavaPlugin plugin, CommandSender sender, String[] args) throws Exception {
        if (!(sender instanceof Player)) {
            PluginMessages.COMMAND.ONLY_PLAYER.sendTo(sender, new Object[0]);
            return null;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            return ((UserCommands)this.getParent()).noArgs(sender);
        }
        ClaimedResidence residence = ResidenceListAPI.getResidence(args[0]);
        if (residence == null || !ResidenceUtils.viewable(residence, player)) {
            PluginMessages.COMMAND.NOT_EXISTS.sendTo(sender, args[0]);
            return null;
        }
        ResidenceData data = ResidenceListAPI.getResidenceData(residence);
        ResidenceInfoUI.open(player, data, null);
        PluginConfig.GUI.OPEN_SOUND.playTo(player);
        return null;
    }

    @Override
    public List<String> tabComplete(JavaPlugin plugin, CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                return SimpleCompleter.objects(args[args.length - 1], ResidenceListAPI.getResidences().values().stream().filter(res -> ResidenceUtils.viewable(res, player)).map(ClaimedResidence::getName));
            }
        }
        return SimpleCompleter.none();
    }
}

