/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.command.user;

import com.artformgames.plugin.residencelist.command.UserCommands;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.conf.PluginMessages;
import com.artformgames.plugin.residencelist.lib.easyplugin.command.SimpleCompleter;
import com.artformgames.plugin.residencelist.lib.easyplugin.command.SubCommand;
import com.artformgames.plugin.residencelist.ui.ResidenceListUI;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class OpenCommand
extends SubCommand<UserCommands> {
    public OpenCommand(@NotNull UserCommands parent, String identifier, String ... aliases) {
        super(parent, identifier, aliases);
    }

    @Override
    public Void execute(JavaPlugin plugin, CommandSender sender, String[] args) throws Exception {
        if (!(sender instanceof Player)) {
            PluginMessages.COMMAND.ONLY_PLAYER.sendTo(sender, new Object[0]);
            return null;
        }
        Player player = (Player)sender;
        ResidencePlayer owner = null;
        if (args.length > 0 && (owner = Residence.getInstance().getPlayerManager().getResidencePlayer(args[0])) == null) {
            PluginMessages.COMMAND.UNKNOWN_PLAYER.sendTo(sender, args[0]);
            return null;
        }
        ResidenceListUI.open(player, Optional.ofNullable(owner).map(ResidencePlayer::getName).orElse(null));
        PluginConfig.GUI.OPEN_SOUND.playTo(player);
        return null;
    }

    @Override
    public List<String> tabComplete(JavaPlugin plugin, CommandSender sender, String[] args) {
        if (args.length == 1) {
            return SimpleCompleter.onlinePlayers(args[args.length - 1], 10);
        }
        return SimpleCompleter.none();
    }
}

