/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.conf;

import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.configuration.annotation.ConfigPath;
import com.artformgames.plugin.residencelist.lib.configuration.annotation.HeaderComments;
import com.artformgames.plugin.residencelist.lib.configuration.builder.list.SourceListBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.value.standard.ConfiguredList;
import com.artformgames.plugin.residencelist.lib.configuration.value.standard.ConfiguredValue;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredSound;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.ConfiguredItem;
import com.artformgames.plugin.residencelist.lib.xseries.XMaterial;
import com.artformgames.plugin.residencelist.ui.ResidenceInfoUI;
import com.artformgames.plugin.residencelist.ui.ResidenceListUI;
import com.artformgames.plugin.residencelist.ui.ResidenceManageUI;
import com.artformgames.plugin.residencelist.ui.SelectIconGUI;
import com.artformgames.plugin.residencelist.ui.admin.ResidenceAdminUI;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.Sound;

@ConfigPath(root=true)
public interface PluginConfig
extends Configuration {
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final ConfiguredValue<Boolean> DEBUG = ConfiguredValue.of(Boolean.class, false);
    @HeaderComments(value={"Statistics Settings", "This option is used to help developers count plug-in versions and usage, and it will never affect performance and user experience.", "Of course, you can also choose to turn it off here for this plugin,", "or turn it off for all plugins in the configuration file under \"plugins/bStats\"."})
    public static final ConfiguredValue<Boolean> METRICS = ConfiguredValue.of(Boolean.class, true);
    @HeaderComments(value={"Check update settings", "This option is used by the plug-in to determine whether to check for updates.", "If you do not want the plug-in to check for updates and prompt you, you can choose to close.", "Checking for updates is an asynchronous operation that will never affect performance and user experience."})
    public static final ConfiguredValue<Boolean> CHECK_UPDATE = ConfiguredValue.of(Boolean.class, true);

    public static interface GUI
    extends Configuration {
        @HeaderComments(value={"The sound played when the GUI is opened."})
        public static final ConfiguredSound OPEN_SOUND = ConfiguredSound.of(Sound.ENTITY_EXPERIENCE_ORB_PICKUP);
        @HeaderComments(value={"The sound played when the player click the buttons in GUI."})
        public static final ConfiguredSound CLICK_SOUND = ConfiguredSound.of(Sound.UI_BUTTON_CLICK);
        public static final Class<?> LIST = ResidenceListUI.CONFIG.class;
        public static final Class<?> INFO = ResidenceInfoUI.CONFIG.class;
        public static final Class<?> MANAGE = ResidenceManageUI.CONFIG.class;
        public static final Class<?> ADMIN = ResidenceAdminUI.CONFIG.class;
        public static final Class<?> SELECT = SelectIconGUI.CONFIG.class;
    }

    public static interface ICON
    extends Configuration {
        @HeaderComments(value={"The icon of the residence list."})
        public static final ConfiguredItem INFO = ConfiguredItem.create().defaultType(Material.GRASS_BLOCK).defaultName("&7# &f%(name)").defaultLore("{  &f&o}#description#{1,1}", "&7Owner: &f%(owner)", "&7Size: &f%(size) &7block(s)", "&7Members: &f%(members)", "&7Rates: &a%(likes) &7likes, &c%(dislikes) &7dislikes.", "#click-lore#{1,0}").params("name", "owner", "members", "size", "likes", "dislikes").build();
        public static final ConfiguredItem EMPTY = ConfiguredItem.create().defaultType(Material.BLACK_STAINED_GLASS_PANE).defaultName("&7  ").build();

        public static interface PAGE
        extends Configuration {
            public static final ConfiguredItem PREVIOUS_PAGE = ConfiguredItem.create().defaultType(Material.ARROW).defaultName("&fPrevious page").defaultLore(" ", "&f  Left click to view the previous page.", "&f  Right click to view the first page.", " ").build();
            public static final ConfiguredItem NO_PREVIOUS_PAGE = ConfiguredItem.create().defaultType(Material.ARROW).defaultName("&fPrevious page").defaultLore(" ", "&f  There is no previous page.", " ").build();
            public static final ConfiguredItem NEXT_PAGE = ConfiguredItem.create().defaultType(Material.ARROW).defaultName("&fNext page").defaultLore(" ", "&f  Left click to view the next page.", "&f  Right click to view the last page.", " ").build();
            public static final ConfiguredItem NO_NEXT_PAGE = ConfiguredItem.create().defaultType(Material.ARROW).defaultName("&fNext page").defaultLore(" ", "&f  There is no next page.", " ").build();
        }

        public static interface RATE
        extends Configuration {
            public static final ConfiguredItem LIKE = ConfiguredItem.create().defaultType(Material.PLAYER_HEAD).defaultName("&7From &f%(owner)").defaultLore("{&7-  &f&o}#comment#{1,1}", "&7Commented at %(date),", "&7This user &arecommended &7this residence.", "#click-lore#{1,0}").params("owner", "date").build();
            public static final ConfiguredItem DISLIKE = ConfiguredItem.create().defaultType(Material.PLAYER_HEAD).defaultName("&7From &f%(owner)").defaultLore("{  &f&o}#comment#{1}", "&7", "&7Commented at %(date)", "&7This user &cnot recommended &7this residence.", "#click-lore#{1,0}").params("owner", "date").build();
        }
    }

    public static interface SETTINGS
    extends Configuration {
        @HeaderComments(value={"Remove info data when failed to load.", "  true = Delete the info data, false = Only notify, keep the info data."})
        public static final ConfiguredValue<Boolean> AUTO_REMOVE = ConfiguredValue.of(Boolean.class, true);
        @HeaderComments(value={"Default residence status (Public = true / Private = false)"})
        public static final ConfiguredValue<Boolean> DEFAULT_STATUS = ConfiguredValue.of(Boolean.class, true);
        @HeaderComments(value={"How many letters are displayed per line in the residence description."})
        public static final ConfiguredValue<Integer> LETTERS_PRE_LINE = ConfiguredValue.of(Integer.class, 35);
        @HeaderComments(value={"The unsuitable icon types for the residence list."})
        public static final ConfiguredList<Material> BLOCKED_ICON_TYPES = ((SourceListBuilder)((SourceListBuilder)ConfiguredList.builderOf(Material.class).fromString().parse(s -> Objects.requireNonNull(XMaterial.matchXMaterial(s).orElseThrow().parseMaterial()))).serialize(d -> XMaterial.matchXMaterial(d).name())).defaults((V[])new Material[]{Material.CHEST, Material.CHAIN, Material.REDSTONE}).build();
    }
}

