/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.conf;

import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.configuration.annotation.ConfigPath;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.ColorParser;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredMessage;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredSound;
import com.artformgames.plugin.residencelist.lib.minedown.MineDown;
import java.util.function.BiFunction;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@ConfigPath(root=true)
public interface PluginMessages
extends Configuration {
    public static final ConfiguredMessage<BaseComponent[]> LOAD_FAILED = ((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lSorry! &fBut your residence data failed to load, please rejoin!")).build();

    @NotNull
    public static ConfiguredMessage.Builder<BaseComponent[]> value() {
        return (ConfiguredMessage.Builder)ConfiguredMessage.create(PluginMessages.getParser()).dispatcher((sender, message) -> {
            for (BaseComponent[] baseComponents : message) {
                sender.spigot().sendMessage(baseComponents);
            }
        });
    }

    @NotNull
    public static BiFunction<CommandSender, String, BaseComponent[]> getParser() {
        return PluginMessages::parse;
    }

    @NotNull
    public static BaseComponent[] parse(@NotNull CommandSender sender, @NotNull String message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        return MineDown.parse(ColorParser.parse(message), new String[0]);
    }

    public static interface EDIT
    extends Configuration {
        public static final ConfiguredSound EDIT_SOUND = ConfiguredSound.of(Sound.ENTITY_CHICKEN_EGG, 0.5f);
        public static final ConfiguredSound SUCCESS_SOUND = ConfiguredSound.of(Sound.BLOCK_LEVER_CLICK, 0.5f);
        public static final ConfiguredSound FAILED_SOUND = ConfiguredSound.of(Sound.ENTITY_VILLAGER_NO, 0.5f);
        public static final ConfiguredMessage<BaseComponent[]> NAME = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou are setting up nickname for residence &e%(residence)&f, please enter in chat.", "&fRemember that a nickname should be &eless than 16 characters&f.", "&fYou can enter '&e#cancel&f' to cancel this operation.")).params("residence")).build();
        public static final ConfiguredMessage<BaseComponent[]> DESCRIPTION = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou are editing description for residence &e%(residence)&f, please enter in chat.", "&fRemember that you can use '&e\\\\n&f' to wrap lines.", "&fYou can enter '&e#cancel&f' to cancel this operation.")).params("residence")).build();
        public static final ConfiguredMessage<BaseComponent[]> NAME_TOO_LONG = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lSorry! &fBut the nickname that you input is too long,", "&fRemember that a nickname should be &eless than 16 characters&f.")).params("residence")).build();
        public static final ConfiguredMessage<BaseComponent[]> NAME_UPDATED = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou have successfully updated the nickname of residence &e%(residence)&f!")).params("residence")).build();
        public static final ConfiguredMessage<BaseComponent[]> DESCRIPTION_UPDATED = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou have successfully updated the description of residence &e%(residence)&f!")).params("residence")).build();
        public static final ConfiguredMessage<BaseComponent[]> ICON_UPDATED = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou have successfully updated the icon of residence &e%(residence)&f!")).params("residence")).build();
        public static final ConfiguredMessage<BaseComponent[]> ICON_BLOCKED = ((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou cannot select this material as residence icon!")).build();
    }

    public static interface COMMENT
    extends Configuration {
        public static final ConfiguredSound ASK_SOUND = ConfiguredSound.of(Sound.ENTITY_CHICKEN_EGG, 0.5f);
        public static final ConfiguredSound YES_SOUND = ConfiguredSound.of(Sound.ENTITY_VILLAGER_YES, 0.5f);
        public static final ConfiguredSound NO_SOUND = ConfiguredSound.of(Sound.ENTITY_VILLAGER_NO, 0.5f);
        public static final ConfiguredMessage<BaseComponent[]> NOTIFY = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou are commenting for residence &e%(residence)&f, please enter your comment in chat.", "&fYou can enter '&e#cancel&f' to cancel this operation.")).params("residence")).build();
    }

    public static interface TELEPORT
    extends Configuration {
        public static final ConfiguredSound SOUND = ConfiguredSound.of(Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f);
        public static final ConfiguredMessage<BaseComponent[]> NO_LOCATION = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lSorry! &fBut you cannot teleport to &e%(residence) &fyet!")).params("residence")).build();
    }

    public static interface UNPIN
    extends Configuration {
        public static final ConfiguredSound SOUND = ConfiguredSound.of(Sound.BLOCK_ANVIL_BREAK, 0.5f);
        public static final ConfiguredMessage<BaseComponent[]> MESSAGE = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou have unpinned the residence &e%(residence)&f!")).params("residence")).build();
    }

    public static interface PIN
    extends Configuration {
        public static final ConfiguredSound SOUND = ConfiguredSound.of("BLOCK_ANVIL_PLACE");
        public static final ConfiguredMessage<BaseComponent[]> MESSAGE = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fYou have successfully pinned the residence &e%(residence)&f!")).params("residence")).build();
    }

    public static interface RELOAD
    extends Configuration {
        public static final ConfiguredMessage<BaseComponent[]> START = ((ConfiguredMessage.Builder)PluginMessages.value().defaults("&fReloading the plugin configurations...")).build();
        public static final ConfiguredMessage<BaseComponent[]> SUCCESS = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&a&lSuccess! &fThe plugin configurations has been reloaded, cost &a%(time)&fms.")).params("time")).build();
        public static final ConfiguredMessage<BaseComponent[]> FAILED = ((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lFailed! &fThe plugin configurations failed to reload.")).build();
    }

    public static interface COMMAND
    extends Configuration {
        public static final ConfiguredMessage<BaseComponent[]> USER = ((ConfiguredMessage.Builder)PluginMessages.value().defaults("&e&lResidenceList &fCommands &7(/reslist)", "&8#&f open &e[player]", "&8-&7 Open the residence list gui.", "&8#&f info &e<residence>", "&8-&7 Display the residence info", "&8#&f edit &e<residence>", "&8-&7 Open the residence edit gui")).build();
        public static final ConfiguredMessage<BaseComponent[]> ADMIN = ((ConfiguredMessage.Builder)PluginMessages.value().defaults("&e&lResidenceList &fAdmin Commands &7(/reslistadmin)", "&8#&f open &e[player]", "&8-&7 Open the admin manage GUI.", "&8#&f edit &e<residence>", "&8-&7 Open the residence edit gui", "&8#&f reload", "&8-&7 Reload the configuration file.")).build();
        public static final ConfiguredMessage<BaseComponent[]> NO_PERMISSION = ((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lSorry! &fBut you dont have enough permissions to do that!")).build();
        public static final ConfiguredMessage<BaseComponent[]> ONLY_PLAYER = ((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lSorry! &fBut this command only can be executed by a player!")).build();
        public static final ConfiguredMessage<BaseComponent[]> NOT_EXISTS = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lSorry! &fThere is currently no residence with name &e#%(residence) &f!")).params("residence")).build();
        public static final ConfiguredMessage<BaseComponent[]> UNKNOWN_PLAYER = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lSorry! &fThere is currently no player named &e#%(name) &f!")).params("name")).build();
        public static final ConfiguredMessage<BaseComponent[]> NOT_OWNER = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)PluginMessages.value().defaults("&c&lSorry! &fBut you are not the owner of residence &e#%(residence) &f!")).params("residence", "residence_nickname")).build();
    }
}

