/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.adapter;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueParser;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueSerializer;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueAdapter<TYPE>
implements ValueSerializer<TYPE>,
ValueParser<TYPE> {
    @NotNull
    protected final ValueType<TYPE> type;
    @Nullable
    protected ValueSerializer<TYPE> serializer;
    @Nullable
    protected ValueParser<TYPE> deserializer;

    public ValueAdapter(@NotNull ValueType<TYPE> type) {
        this(type, null, null);
    }

    public ValueAdapter(@NotNull ValueType<TYPE> type, @Nullable ValueSerializer<TYPE> serializer, @Nullable ValueParser<TYPE> parser) {
        this.type = type;
        this.serializer = serializer;
        this.deserializer = parser;
    }

    @NotNull
    public ValueType<TYPE> type() {
        return this.type;
    }

    @Nullable
    public ValueSerializer<TYPE> serializer() {
        return this.serializer;
    }

    @Nullable
    public ValueParser<TYPE> parser() {
        return this.deserializer;
    }

    public ValueAdapter<TYPE> serializer(@Nullable ValueSerializer<TYPE> serializer) {
        this.serializer = serializer;
        return this;
    }

    public ValueAdapter<TYPE> parser(@Nullable ValueParser<TYPE> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull ConfigurationHolder<?> holder, @NotNull ValueType<? super TYPE> type, @NotNull TYPE value) throws Exception {
        if (this.serializer == null) {
            throw new UnsupportedOperationException("Serializer is not supported");
        }
        return this.serializer.serialize(holder, type, (TYPE)value);
    }

    @Override
    @Nullable
    public TYPE parse(@NotNull ConfigurationHolder<?> holder, @NotNull ValueType<? super TYPE> type, @NotNull Object value) throws Exception {
        if (this.deserializer == null) {
            throw new UnsupportedOperationException("Deserializer is not supported");
        }
        return this.deserializer.parse(holder, type, value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ValueAdapter)) {
            return false;
        }
        ValueAdapter that = (ValueAdapter)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hashCode(this.type);
    }
}

