/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.adapter;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueParser;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueSerializer;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueAdapterRegistry {
    protected final Set<ValueAdapter<?>> adapters = new HashSet();

    public <FROM, TO> void register(@NotNull Class<FROM> from, @NotNull Class<TO> to, @Nullable DataFunction<FROM, TO> parser, @Nullable DataFunction<TO, FROM> serializer) {
        this.register(ValueType.of(from), ValueType.of(to), parser, serializer);
    }

    public <FROM, TO> void register(@NotNull ValueType<FROM> from, @NotNull ValueType<TO> to, @Nullable DataFunction<FROM, TO> parser, @Nullable DataFunction<TO, FROM> serializer) {
        ValueAdapter fromAdapter = this.adapterOf((Object)from);
        if (fromAdapter == null) {
            throw new IllegalArgumentException("No adapter for type " + from);
        }
        this.register(to, serializer == null ? null : (provider, type, value) -> fromAdapter.serialize(provider, from, (ValueType)serializer.handle(value)), parser == null ? null : (provider, type, data) -> parser.handle(fromAdapter.parse(provider, from, data)));
    }

    public void register(ValueAdapter<?> ... adapter) {
        this.adapters.addAll(Arrays.asList(adapter));
    }

    public <T> void register(@NotNull Class<T> type, @NotNull ValueSerializer<T> serializer) {
        this.register(ValueType.of(type), serializer);
    }

    public <T> void register(@NotNull ValueType<T> type, @NotNull ValueSerializer<T> serializer) {
        ValueAdapter<ValueType<T>> existing = this.adapterOf((T)type);
        if (existing != null) {
            existing.serializer(serializer);
        } else {
            this.register(new ValueAdapter<T>(type, serializer, null));
        }
    }

    public <T> void register(@NotNull Class<T> type, @NotNull ValueParser<T> deserializer) {
        this.register(ValueType.of(type), deserializer);
    }

    public <T> void register(@NotNull ValueType<T> type, @NotNull ValueParser<T> deserializer) {
        ValueAdapter<ValueType<T>> existing = this.adapterOf((T)type);
        if (existing != null) {
            existing.parser(deserializer);
        } else {
            this.register(new ValueAdapter<T>(type, null, deserializer));
        }
    }

    public <T> void register(@NotNull ValueType<T> type, @Nullable ValueSerializer<T> serializer, @Nullable ValueParser<T> deserializer) {
        if (serializer == null && deserializer == null) {
            return;
        }
        ValueAdapter<ValueType<T>> existing = this.adapterOf((T)type);
        if (existing != null) {
            if (serializer != null) {
                existing.serializer(serializer);
            }
            if (deserializer != null) {
                existing.parser(deserializer);
            }
        } else {
            this.register(new ValueAdapter<T>(type, serializer, deserializer));
        }
    }

    public void unregister(@NotNull Class<?> type) {
        this.unregister(ValueType.of(type));
    }

    public void unregister(@NotNull ValueType<?> type) {
        this.adapters.removeIf(adapter -> adapter.type().equals(type));
    }

    @Nullable
    public <T> ValueAdapter<T> adapterOf(@NotNull ValueType<T> type) {
        ValueAdapter matched = this.adapters.stream().filter(adapter -> adapter.type().equals(type)).findFirst().orElse(null);
        if (matched != null) {
            return matched;
        }
        return this.adapters.stream().filter(adapter -> adapter.type().isSubtypeOf(type)).findFirst().orElse(null);
    }

    public <T> ValueAdapter<T> adapterOf(@NotNull T value) {
        return this.adapterOf((T)ValueType.of(value));
    }

    public <T> ValueAdapter<T> adapterOf(@NotNull Class<T> type) {
        return this.adapterOf((T)ValueType.of(type));
    }

    public <T> T deserialize(@NotNull ConfigurationHolder<?> holder, @NotNull Class<T> type, @Nullable Object source) throws Exception {
        return this.deserialize(holder, ValueType.of(type), source);
    }

    public <T> T deserialize(@NotNull ConfigurationHolder<?> holder, @NotNull ValueType<T> type, @Nullable Object source) throws Exception {
        if (source == null) {
            return null;
        }
        if (type.isInstance(source)) {
            return type.cast(source);
        }
        ValueAdapter<ValueType<T>> adapter = this.adapterOf((T)type);
        if (adapter == null) {
            throw new RuntimeException("No adapter for type " + type);
        }
        return (T)adapter.parse(holder, type, source);
    }

    @Nullable
    public <T> Object serialize(@NotNull ConfigurationHolder<?> holder, @Nullable T value) throws Exception {
        if (value == null) {
            return null;
        }
        ValueType<T> type = ValueType.of(value);
        ValueAdapter<ValueType<T>> adapter = this.adapterOf((T)type);
        if (adapter == null) {
            return value;
        }
        return adapter.serialize(holder, (ValueType<ValueType<T>>)type, (ValueType<T>)value);
    }
}

