/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.adapter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class ValueType<T> {
    public static final ValueType<String> STRING = ValueType.ofPrimitiveType(String.class);
    public static final ValueType<Integer> INTEGER = ValueType.ofPrimitiveType(Integer.class);
    public static final ValueType<Integer> INTEGER_TYPE = ValueType.ofPrimitiveType(Integer.TYPE);
    public static final ValueType<Long> LONG = ValueType.ofPrimitiveType(Long.class);
    public static final ValueType<Long> LONG_TYPE = ValueType.ofPrimitiveType(Long.TYPE);
    public static final ValueType<Double> DOUBLE = ValueType.ofPrimitiveType(Double.class);
    public static final ValueType<Double> DOUBLE_TYPE = ValueType.ofPrimitiveType(Double.TYPE);
    public static final ValueType<Float> FLOAT = ValueType.ofPrimitiveType(Float.class);
    public static final ValueType<Float> FLOAT_TYPE = ValueType.ofPrimitiveType(Float.TYPE);
    public static final ValueType<Boolean> BOOLEAN = ValueType.ofPrimitiveType(Boolean.class);
    public static final ValueType<Boolean> BOOLEAN_TYPE = ValueType.ofPrimitiveType(Boolean.TYPE);
    public static final ValueType<Byte> BYTE = ValueType.ofPrimitiveType(Byte.class);
    public static final ValueType<Byte> BYTE_TYPE = ValueType.ofPrimitiveType(Byte.TYPE);
    public static final ValueType<Short> SHORT = ValueType.ofPrimitiveType(Short.class);
    public static final ValueType<Short> SHORT_TYPE = ValueType.ofPrimitiveType(Short.TYPE);
    public static final ValueType<Character> CHAR = ValueType.ofPrimitiveType(Character.class);
    public static final ValueType<Character> CHAR_TYPE = ValueType.ofPrimitiveType(Character.TYPE);
    public static final ValueType<?>[] PRIMITIVE_TYPES = new ValueType[]{STRING, INTEGER, LONG, DOUBLE, FLOAT, BOOLEAN, BYTE, SHORT, CHAR, INTEGER_TYPE, LONG_TYPE, DOUBLE_TYPE, FLOAT_TYPE, BOOLEAN_TYPE, BYTE_TYPE, SHORT_TYPE, CHAR_TYPE};
    private final Type type;

    public static <T> ValueType<T> of(@NotNull T value) {
        return ValueType.of(value.getClass());
    }

    public static <T> ValueType<T> of(Type type) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null");
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            for (ValueType<?> valueType : PRIMITIVE_TYPES) {
                if (valueType.getRawType() != clazz) continue;
                return valueType;
            }
        }
        return new ValueType<T>(type){};
    }

    public static <T> ValueType<T> of(@NotNull Class<T> clazz) {
        return ValueType.of(clazz);
    }

    public static <T> ValueType<List<T>> ofList(@NotNull Class<T> paramType) {
        return ValueType.of(List.class, paramType);
    }

    public static <T> ValueType<T> of(final Class<?> rawType, final Type ... types) {
        ParameterizedType parameterizedType = new ParameterizedType(){

            @Override
            @NotNull
            public @NotNull Type @NotNull [] getActualTypeArguments() {
                return types;
            }

            @Override
            @NotNull
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
        return ValueType.of(parameterizedType);
    }

    private static <T> ValueType<T> ofPrimitiveType(Class<T> clazz) {
        return new ValueType<T>(clazz){};
    }

    protected ValueType() {
        this.type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private ValueType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isSubtypeOf(Class<?> target) {
        Class<?> rawType = this.getRawType();
        return target.isAssignableFrom(rawType);
    }

    public boolean isSubtypeOf(ValueType<?> target) {
        return target.isSubtypeOf(this.getRawType());
    }

    public boolean isInstance(Object obj) {
        return obj != null && this.getRawType().isInstance(obj);
    }

    public Class<?> getRawType() {
        ParameterizedType pt;
        Type raw;
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof ParameterizedType && (raw = (pt = (ParameterizedType)this.type).getRawType()) instanceof Class) {
            return (Class)raw;
        }
        throw new IllegalStateException("Unsupported type: " + this.type);
    }

    public T cast(Object obj) {
        if (!this.isInstance(obj)) {
            throw new ClassCastException("Cannot cast object " + obj + " to type " + this);
        }
        return (T)obj;
    }

    public String toString() {
        if (this.type instanceof Class) {
            return ((Class)this.type).getName();
        }
        if (this.type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.type;
            Type raw = pt.getRawType();
            StringBuilder sb = new StringBuilder();
            sb.append(raw.getClass().getName());
            sb.append('<');
            Type[] args = pt.getActualTypeArguments();
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(args[i].getTypeName());
            }
            sb.append('>');
            return sb.toString();
        }
        return this.type.getTypeName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ValueType) {
            return Objects.equals(this.type, ((ValueType)obj).type);
        }
        if (obj instanceof Type) {
            return Objects.equals(this.type, obj);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.type);
    }
}

