/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.adapter.strandard;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueParser;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PrimitiveAdapter<T>
extends ValueAdapter<T> {
    public static final String[] TRUE_VALUES = new String[]{"true", "yes", "on", "1", "enabled", "enable", "active"};
    public static final String[] FALSE_VALUES = new String[]{"false", "no", "off", "0", "disabled", "disable", "inactive"};

    public static ValueAdapter<Enum<?>> ofEnum() {
        ValueAdapter adapter = new ValueAdapter(new ValueType<Enum<?>>(){});
        adapter.parser((provider, type, data) -> Enum.valueOf(type.getRawType(), data.toString()));
        adapter.serializer((provider, type, value) -> value.name());
        return adapter;
    }

    public static PrimitiveAdapter<String> ofString() {
        return PrimitiveAdapter.of(String.class, o -> o instanceof String ? (String)o : o.toString());
    }

    public static PrimitiveAdapter<Boolean> ofBoolean() {
        return PrimitiveAdapter.of(Boolean.class, data -> {
            if (data instanceof Boolean) {
                return (Boolean)data;
            }
            String v = data.toString().trim();
            if (Arrays.stream(TRUE_VALUES).anyMatch(v::equalsIgnoreCase)) {
                return true;
            }
            if (Arrays.stream(FALSE_VALUES).anyMatch(v::equalsIgnoreCase)) {
                return false;
            }
            throw new IllegalArgumentException("Cannot parse boolean from " + data);
        });
    }

    public static PrimitiveAdapter<Boolean> ofBooleanType() {
        return PrimitiveAdapter.of(Boolean.TYPE, o -> o instanceof Boolean ? (Boolean)o : Boolean.parseBoolean(o.toString()));
    }

    public static PrimitiveAdapter<Character> ofCharacter() {
        return PrimitiveAdapter.of(Character.class, o -> Character.valueOf(o instanceof Character ? ((Character)o).charValue() : o.toString().charAt(0)));
    }

    public static PrimitiveAdapter<Character> ofCharacterType() {
        return PrimitiveAdapter.of(Character.TYPE, o -> Character.valueOf(o instanceof Character ? ((Character)o).charValue() : o.toString().charAt(0)));
    }

    public static PrimitiveAdapter<Integer> ofInteger() {
        return PrimitiveAdapter.ofNumber(Integer.class, Number::intValue, Integer::parseInt);
    }

    public static PrimitiveAdapter<Integer> ofIntegerType() {
        return PrimitiveAdapter.ofNumber(Integer.TYPE, Number::intValue, Integer::parseInt);
    }

    public static PrimitiveAdapter<Long> ofLong() {
        return PrimitiveAdapter.ofNumber(Long.class, Number::longValue, Long::parseLong);
    }

    public static PrimitiveAdapter<Long> ofLongType() {
        return PrimitiveAdapter.ofNumber(Long.TYPE, Number::longValue, Long::parseLong);
    }

    public static PrimitiveAdapter<Double> ofDouble() {
        return PrimitiveAdapter.ofNumber(Double.class, Number::doubleValue, Double::parseDouble);
    }

    public static PrimitiveAdapter<Double> ofDoubleType() {
        return PrimitiveAdapter.ofNumber(Double.TYPE, Number::doubleValue, Double::parseDouble);
    }

    public static PrimitiveAdapter<Float> ofFloat() {
        return PrimitiveAdapter.ofNumber(Float.class, Number::floatValue, Float::parseFloat);
    }

    public static PrimitiveAdapter<Float> ofFloatType() {
        return PrimitiveAdapter.ofNumber(Float.TYPE, Number::floatValue, Float::parseFloat);
    }

    public static PrimitiveAdapter<Short> ofShort() {
        return PrimitiveAdapter.ofNumber(Short.class, Number::shortValue, Short::parseShort);
    }

    public static PrimitiveAdapter<Short> ofShortType() {
        return PrimitiveAdapter.ofNumber(Short.TYPE, Number::shortValue, Short::parseShort);
    }

    public static PrimitiveAdapter<Byte> ofByte() {
        return PrimitiveAdapter.ofNumber(Byte.class, Number::byteValue, Byte::parseByte);
    }

    public static PrimitiveAdapter<Byte> ofByteType() {
        return PrimitiveAdapter.ofNumber(Byte.TYPE, Number::byteValue, Byte::parseByte);
    }

    public static <T> PrimitiveAdapter<T> of(@NotNull Class<T> clazz, @NotNull DataFunction<Object, T> function) {
        return new PrimitiveAdapter<Object>(clazz, (p, type, data) -> function.handle(data));
    }

    public static <T extends Number> PrimitiveAdapter<T> ofNumber(@NotNull Class<T> numberClass, @NotNull DataFunction<Number, T> castFunction, @NotNull DataFunction<String, T> parseFunction) {
        return PrimitiveAdapter.of(numberClass, o -> o instanceof Number ? (Number)((Number)castFunction.handle((Number)o)) : (Number)((Number)parseFunction.handle(o.toString())));
    }

    protected PrimitiveAdapter(@NotNull Class<T> valueType, @NotNull ValueParser<T> deserializer) {
        super(ValueType.of(valueType), (provider, type, value) -> value, deserializer);
    }
}

