/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.builder;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataValidator;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueValidator;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetaHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetadata;
import com.artformgames.plugin.residencelist.lib.configuration.value.ConfigValue;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public abstract class AbstractConfigBuilder<TYPE, UNIT, RESULT extends ConfigValue<TYPE, UNIT>, HOLDER extends ConfigurationHolder<?>, SELF extends AbstractConfigBuilder<TYPE, UNIT, RESULT, HOLDER, SELF>> {
    protected final Class<? super HOLDER> providerClass;
    protected final ValueType<TYPE> type;
    @Nullable
    protected HOLDER holder;
    @Nullable
    protected String path;
    @NotNull
    protected ValueValidator<UNIT> valueValidator = ValueValidator.none();
    protected @NotNull Supplier<@Nullable TYPE> defaultValueSupplier = () -> null;
    @NotNull
    protected BiConsumer<ConfigurationHolder<?>, String> initializer = (h, p) -> {};

    protected AbstractConfigBuilder(Class<? super HOLDER> providerClass, ValueType<TYPE> type) {
        this.providerClass = providerClass;
        this.type = type;
    }

    @NotNull
    public ValueType<TYPE> type() {
        return this.type;
    }

    protected abstract SELF self();

    @NotNull
    public abstract RESULT build();

    public SELF holder(@Nullable HOLDER holder) {
        this.holder = holder;
        return this.self();
    }

    public SELF path(@Nullable String path) {
        this.path = path;
        return this.self();
    }

    public SELF validator(@NotNull ValueValidator<UNIT> validator) {
        this.valueValidator = validator;
        return this.self();
    }

    public SELF validator(@NotNull DataValidator<? super UNIT> validator) {
        return this.validator((ConfigurationHolder<?> h, UNIT value) -> validator.validate((Object)value));
    }

    public SELF validate(@NotNull ValueValidator<? super UNIT> validator) {
        return this.validator(this.valueValidator.and(validator));
    }

    public SELF validate(@NotNull DataValidator<? super UNIT> validator) {
        return this.validate((ConfigurationHolder<?> h, ? super UNIT value) -> validator.validate((Object)value));
    }

    public SELF validate(@NotNull Predicate<? super UNIT> condition, @NotNull Exception exception) {
        return this.validate((ConfigurationHolder<?> h, ? super UNIT value) -> {
            if (!condition.test((Object)value)) {
                throw exception;
            }
        });
    }

    public SELF validate(@NotNull Predicate<? super UNIT> condition, @NotNull String msg) {
        return this.validate((ConfigurationHolder<?> h, ? super UNIT value) -> {
            if (!condition.test((Object)value)) {
                throw new IllegalArgumentException(msg);
            }
        });
    }

    public SELF initializer(@NotNull BiConsumer<ConfigurationHolder<?>, String> initializer) {
        this.initializer = initializer;
        return this.self();
    }

    public SELF append(@NotNull BiConsumer<ConfigurationHolder<?>, String> initializer) {
        return this.initializer(initializer.andThen(initializer));
    }

    public SELF append(@NotNull Consumer<ConfigurationHolder<?>> initializer) {
        return this.append((ConfigurationHolder<?> provider, String valuePath) -> initializer.accept((ConfigurationHolder<?>)provider));
    }

    public SELF defaults(@Nullable TYPE defaultValue) {
        return this.defaults(() -> defaultValue);
    }

    public SELF defaults(@NotNull Supplier<@Nullable TYPE> supplier) {
        this.defaultValueSupplier = supplier;
        return this.self();
    }

    public SELF meta(@NotNull @NotNull Consumer<@NotNull ConfigurationMetaHolder> metaConsumer) {
        return this.append((ConfigurationHolder<?> h, String p) -> metaConsumer.accept(h.metadata((String)p)));
    }

    public <M> SELF meta(@NotNull ConfigurationMetadata<M> type, @Nullable M value) {
        return this.meta(h -> h.set(type, value));
    }

    @NotNull
    protected ValueManifest<TYPE, UNIT> buildManifest() {
        return new ValueManifest<TYPE, UNIT>(this.type(), this.defaultValueSupplier, this.valueValidator, this.initializer, (ConfigurationHolder<?>)this.holder, this.path);
    }
}

