/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.builder.impl;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.CommonConfigBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueHandler;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.value.ConfigValue;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSourceBuilder<V, SOURCE, UNIT, RESULT extends ConfigValue<V, UNIT>, SELF extends AbstractSourceBuilder<V, SOURCE, UNIT, RESULT, SELF>>
extends CommonConfigBuilder<V, UNIT, RESULT, SELF> {
    @NotNull
    protected final ValueType<SOURCE> sourceType;
    @NotNull
    protected final ValueType<UNIT> paramType;
    @NotNull
    protected ValueHandler<SOURCE, UNIT> valueParser;
    @NotNull
    protected ValueHandler<UNIT, SOURCE> valueSerializer;

    protected AbstractSourceBuilder(@NotNull ValueType<V> type, @NotNull ValueType<SOURCE> sourceType, @NotNull ValueType<UNIT> paramType, @NotNull ValueHandler<SOURCE, UNIT> parser, @NotNull ValueHandler<UNIT, SOURCE> serializer) {
        super(type);
        this.sourceType = sourceType;
        this.paramType = paramType;
        this.valueParser = parser;
        this.valueSerializer = serializer;
    }

    @NotNull
    public SELF parse(@NotNull DataFunction<SOURCE, UNIT> parser) {
        return this.parse((ConfigurationHolder<?> p, SOURCE source) -> parser.handle(source));
    }

    @NotNull
    public SELF parse(@NotNull ValueHandler<SOURCE, UNIT> parser) {
        this.valueParser = parser;
        return (SELF)((AbstractSourceBuilder)this.self());
    }

    @NotNull
    public SELF serialize(@NotNull ValueHandler<UNIT, SOURCE> serializer) {
        this.valueSerializer = serializer;
        return (SELF)((AbstractSourceBuilder)this.self());
    }

    @NotNull
    public SELF serialize(@NotNull DataFunction<UNIT, SOURCE> serializer) {
        return this.serialize((ConfigurationHolder<?> p, UNIT value) -> serializer.handle(value));
    }

    protected ValueAdapter<UNIT> buildAdapter() {
        return new ValueAdapter<UNIT>(this.paramType).parser((holder, type, data) -> {
            SOURCE source = holder.deserialize(this.sourceType, data);
            return this.valueParser.handle(holder, source);
        }).serializer((holder, type, data) -> {
            SOURCE source = this.valueSerializer.handle(holder, data);
            return holder.serialize(source);
        });
    }
}

