/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.builder.map;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.map.SectionMapBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.builder.map.SourceMapBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueHandler;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ConfigMapBuilder<M extends Map<K, V>, K, V> {
    @NotNull
    protected final @NotNull Supplier<@NotNull M> constructor;
    @NotNull
    protected final ValueType<K> keyType;
    @NotNull
    protected final ValueType<V> valueType;

    public ConfigMapBuilder(@NotNull @NotNull Supplier<@NotNull M> constructor, @NotNull ValueType<K> keyType, @NotNull ValueType<V> valueType) {
        this.constructor = constructor;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public <W extends Map<K, V>> ConfigMapBuilder<W, K, V> constructor(@NotNull Supplier<W> supplier) {
        return new ConfigMapBuilder<W, K, V>(supplier, this.keyType, this.valueType);
    }

    @NotNull
    public <S> SourceMapBuilder<M, S, K, V> from(@NotNull Class<S> clazz) {
        return this.from(ValueType.of(clazz));
    }

    @NotNull
    public <S> SourceMapBuilder<M, S, K, V> from(@NotNull ValueType<S> sourceType) {
        return this.from(sourceType, ValueHandler.required(this.keyType), ValueHandler.stringValue(), ValueHandler.required(this.valueType), ValueHandler.required());
    }

    @NotNull
    public <S> SourceMapBuilder<M, S, K, V> from(@NotNull ValueType<S> sourceType, @NotNull ValueHandler<String, K> keyParser, @NotNull ValueHandler<K, String> keySerializer, @NotNull ValueHandler<S, V> valueParser, @NotNull ValueHandler<V, S> valueSerializer) {
        return new SourceMapBuilder<M, S, K, V>(this.constructor, sourceType, this.keyType, this.valueType, keyParser, keySerializer, valueParser, valueSerializer);
    }

    @NotNull
    public SourceMapBuilder<M, String, K, V> fromString() {
        return this.from(ValueType.STRING, ValueHandler.required(this.keyType), ValueHandler.stringValue(), ValueHandler.required(this.valueType), ValueHandler.stringValue());
    }

    @NotNull
    public SectionMapBuilder<M, K, V> fromSection() {
        return this.fromSection(ValueHandler.required(this.keyType), ValueHandler.stringValue(), ValueHandler.required(this.valueType), ValueHandler.required());
    }

    @NotNull
    public SectionMapBuilder<M, K, V> fromSection(@NotNull ValueHandler<String, K> keyParser, @NotNull ValueHandler<K, String> keySerializer, @NotNull ValueHandler<ConfigureSection, V> valueParser, @NotNull ValueHandler<V, Map<String, Object>> valueSerializer) {
        return new SectionMapBuilder<M, K, V>(this.constructor, this.keyType, this.valueType, keyParser, keySerializer, valueParser, valueSerializer);
    }
}

