/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.builder.map;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.map.ConfigMapBuilder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ConfigMapCreator<K, V> {
    @NotNull
    protected final ValueType<K> keyType;
    @NotNull
    protected final ValueType<V> valueType;

    public ConfigMapCreator(@NotNull ValueType<K> keyType, @NotNull ValueType<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @NotNull
    public <M extends Map<K, V>> ConfigMapBuilder<M, K, V> constructor(@NotNull @NotNull Supplier<@NotNull M> mapSuppler) {
        return new ConfigMapBuilder<M, K, V>(mapSuppler, this.keyType, this.valueType);
    }

    @NotNull
    public <W extends Map<K, V>> ConfigMapBuilder<W, K, V> constructor(@NotNull Class<W> type) {
        return this.constructor(() -> {
            try {
                return (Map)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    public ConfigMapBuilder<HashMap<K, V>, K, V> asHashMap() {
        return this.constructor(HashMap::new);
    }

    @NotNull
    public ConfigMapBuilder<LinkedHashMap<K, V>, K, V> asLinkedMap() {
        return this.constructor(LinkedHashMap::new);
    }

    @NotNull
    public ConfigMapBuilder<TreeMap<K, V>, K, V> asTreeMap() {
        return this.constructor(TreeMap::new);
    }

    @NotNull
    public ConfigMapBuilder<TreeMap<K, V>, K, V> asTreeMap(@NotNull Comparator<? super K> comparator) {
        return this.constructor(() -> new TreeMap(comparator));
    }
}

