/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.builder.map;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.impl.AbstractSectionBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueHandler;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import com.artformgames.plugin.residencelist.lib.configuration.value.standard.ConfiguredMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class SectionMapBuilder<MAP extends Map<K, V>, K, V>
extends AbstractSectionBuilder<Map<K, V>, V, ConfiguredMap<K, V>, SectionMapBuilder<MAP, K, V>> {
    @NotNull
    protected final ValueType<K> keyType;
    @NotNull
    protected Supplier<? extends MAP> constructor;
    @NotNull
    protected ValueHandler<String, K> keyParser;
    @NotNull
    protected ValueHandler<K, String> keySerializer;

    public SectionMapBuilder(@NotNull Supplier<? extends MAP> constructor, @NotNull ValueType<K> keyType, @NotNull ValueType<V> valueType, @NotNull ValueHandler<String, K> keyParser, @NotNull ValueHandler<K, String> keySerializer, @NotNull ValueHandler<ConfigureSection, V> valueParser, @NotNull ValueHandler<V, Map<String, Object>> valueSerializer) {
        super(new ValueType<Map<K, V>>(){}, valueType, valueParser, valueSerializer);
        this.keyType = keyType;
        this.constructor = constructor;
        this.keyParser = keyParser;
        this.keySerializer = keySerializer;
    }

    @Override
    @NotNull
    protected SectionMapBuilder<MAP, K, V> self() {
        return this;
    }

    @NotNull
    public SectionMapBuilder<MAP, K, V> parseKey(@NotNull DataFunction<String, K> keyParser) {
        return this.parseKey((ConfigurationHolder<?> holder, String data) -> keyParser.handle((String)data));
    }

    @NotNull
    public SectionMapBuilder<MAP, K, V> parseKey(@NotNull ValueHandler<String, K> keyParser) {
        this.keyParser = keyParser;
        return this;
    }

    @NotNull
    public SectionMapBuilder<MAP, K, V> serializeKey(@NotNull DataFunction<K, String> keySerializer) {
        return this.serializeKey((ConfigurationHolder<?> holder, K data) -> (String)keySerializer.handle(data));
    }

    @NotNull
    public SectionMapBuilder<MAP, K, V> serializeKey(@NotNull ValueHandler<K, String> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    @Override
    @NotNull
    public SectionMapBuilder<MAP, K, V> defaults(@NotNull MAP defaults) {
        return (SectionMapBuilder)this.defaults(() -> defaults);
    }

    @Override
    @NotNull
    public SectionMapBuilder<MAP, K, V> defaults(@NotNull Consumer<MAP> defaults) {
        return (SectionMapBuilder)this.defaults(() -> {
            Map map = (Map)this.constructor.get();
            defaults.accept(map);
            return map;
        });
    }

    @NotNull
    public SectionMapBuilder<MAP, K, V> defaults(@NotNull K key, @NotNull V value) {
        return this.defaults((MAP map) -> map.put(key, value));
    }

    @NotNull
    public ValueAdapter<K> buildKeyAdapter() {
        return new ValueAdapter<K>(this.keyType).parser((holder, type, data) -> {
            String source = holder.deserialize(String.class, data);
            return this.keyParser.handle(holder, source);
        }).serializer((holder, type, data) -> {
            String source = this.keySerializer.handle(holder, data);
            return holder.serialize(source);
        });
    }

    @Override
    @NotNull
    public ConfiguredMap<K, V> build() {
        return new ConfiguredMap(this.buildManifest(), this.constructor, this.buildKeyAdapter(), this.buildAdapter());
    }
}

