/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.builder.map;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.impl.AbstractSourceBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueHandler;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.value.standard.ConfiguredMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class SourceMapBuilder<MAP extends Map<K, V>, SOURCE, K, V>
extends AbstractSourceBuilder<Map<K, V>, SOURCE, V, ConfiguredMap<K, V>, SourceMapBuilder<MAP, SOURCE, K, V>> {
    @NotNull
    protected final ValueType<K> keyType;
    @NotNull
    protected Supplier<? extends MAP> constructor;
    @NotNull
    protected ValueHandler<String, K> keyParser;
    @NotNull
    protected ValueHandler<K, String> keySerializer;

    public SourceMapBuilder(@NotNull Supplier<? extends MAP> constructor, @NotNull ValueType<SOURCE> sourceType, @NotNull ValueType<K> keyType, @NotNull ValueType<V> valueType, @NotNull ValueHandler<String, K> keyParser, @NotNull ValueHandler<K, String> keySerializer, @NotNull ValueHandler<SOURCE, V> valueParser, @NotNull ValueHandler<V, SOURCE> valueSerializer) {
        super(new ValueType<Map<K, V>>(){}, sourceType, valueType, valueParser, valueSerializer);
        this.keyType = keyType;
        this.constructor = constructor;
        this.keyParser = keyParser;
        this.keySerializer = keySerializer;
    }

    @Override
    @NotNull
    protected SourceMapBuilder<MAP, SOURCE, K, V> self() {
        return this;
    }

    @Override
    @NotNull
    public SourceMapBuilder<MAP, SOURCE, K, V> defaults(@NotNull MAP defaults) {
        return (SourceMapBuilder)this.defaults(() -> defaults);
    }

    @Override
    @NotNull
    public SourceMapBuilder<MAP, SOURCE, K, V> defaults(@NotNull Consumer<MAP> defaults) {
        return (SourceMapBuilder)this.defaults(() -> {
            Map map = (Map)this.constructor.get();
            defaults.accept(map);
            return map;
        });
    }

    @NotNull
    public SourceMapBuilder<MAP, SOURCE, K, V> defaults(@NotNull K key, @NotNull V value) {
        return this.defaults((MAP map) -> map.put(key, value));
    }

    @NotNull
    public SourceMapBuilder<MAP, SOURCE, K, V> parseKey(@NotNull DataFunction<String, K> keyParser) {
        return this.parseKey((ConfigurationHolder<?> holder, String data) -> keyParser.handle((String)data));
    }

    @NotNull
    public SourceMapBuilder<MAP, SOURCE, K, V> parseKey(@NotNull ValueHandler<String, K> keyParser) {
        this.keyParser = keyParser;
        return this;
    }

    @NotNull
    public SourceMapBuilder<MAP, SOURCE, K, V> serializeKey(@NotNull DataFunction<K, String> keySerializer) {
        return this.serializeKey((ConfigurationHolder<?> holder, K data) -> (String)keySerializer.handle(data));
    }

    @NotNull
    public SourceMapBuilder<MAP, SOURCE, K, V> serializeKey(@NotNull ValueHandler<K, String> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    @NotNull
    public ValueAdapter<K> buildKeyAdapter() {
        return new ValueAdapter<K>(this.keyType).parser((holder, type, data) -> {
            String source = holder.deserialize(String.class, data);
            return this.keyParser.handle(holder, source);
        }).serializer((holder, type, data) -> {
            String source = this.keySerializer.handle(holder, data);
            return holder.serialize(source);
        });
    }

    @Override
    @NotNull
    public ConfiguredMap<K, V> build() {
        return new ConfiguredMap(this.buildManifest(), this.constructor, this.buildKeyAdapter(), this.buildAdapter());
    }
}

