/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.builder.value;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.value.SectionValueBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.builder.value.SourceValueBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueHandler;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ConfigValueBuilder<V> {
    @NotNull
    protected final ValueType<V> type;

    public ConfigValueBuilder(@NotNull ValueType<V> type) {
        this.type = type;
    }

    @NotNull
    public <S> SourceValueBuilder<S, V> from(@NotNull Class<S> clazz) {
        return this.from(ValueType.of(clazz));
    }

    @NotNull
    public <S> SourceValueBuilder<S, V> from(@NotNull ValueType<S> sourceType) {
        return this.from(sourceType, ValueHandler.required(this.type), ValueHandler.required(sourceType));
    }

    @NotNull
    public <S> SourceValueBuilder<S, V> from(@NotNull ValueType<S> sourceType, @NotNull ValueHandler<S, V> valueParser, @NotNull ValueHandler<V, S> valueSerializer) {
        return new SourceValueBuilder<S, V>(sourceType, this.type, valueParser, valueSerializer);
    }

    @NotNull
    public SourceValueBuilder<String, V> fromString() {
        return this.from(ValueType.STRING, ValueHandler.required(this.type), ValueHandler.stringValue());
    }

    @NotNull
    public SectionValueBuilder<V> fromSection() {
        return this.fromSection(ValueHandler.required(this.type), ValueHandler.required());
    }

    @NotNull
    public SectionValueBuilder<V> fromSection(@NotNull ValueHandler<ConfigureSection, V> valueParser, @NotNull ValueHandler<V, ? extends Map<String, Object>> valueSerializer) {
        return new SectionValueBuilder<V>(this.type, valueParser, valueSerializer);
    }
}

