/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.commentable;

import com.artformgames.plugin.residencelist.lib.configuration.commentable.CommentableMeta;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.loader.ConfigurationInitializer;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.StandardOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Commentable {
    private Commentable() {
        throw new UnsupportedOperationException();
    }

    public static void registerMeta(@NotNull ConfigurationInitializer initializer) {
        CommentableMeta.register(initializer);
    }

    @Nullable
    public static String getInlineComment(@NotNull ConfigurationHolder<?> holder, @NotNull String path) {
        String comment = Commentable.getInlineComment(holder, path, null);
        if (comment != null) {
            return comment;
        }
        String sep = String.valueOf(holder.option(StandardOptions.PATH_SEPARATOR));
        String[] keys = path.split(Pattern.quote(sep));
        if (keys.length == 1) {
            return null;
        }
        for (int i = 1; i < keys.length; ++i) {
            String childKey;
            String parentKey = String.join((CharSequence)sep, Arrays.copyOfRange(keys, 0, i));
            comment = Commentable.getInlineComment(holder, parentKey, childKey = String.join((CharSequence)sep, Arrays.copyOfRange(keys, i, keys.length)));
            if (comment == null) continue;
            return comment;
        }
        return null;
    }

    @Nullable
    public static String getInlineComment(@NotNull ConfigurationHolder<?> holder, @NotNull String path, @Nullable String sectionKey) {
        Map<String, String> pathComment = holder.metadata(path).get(CommentableMeta.INLINE);
        if (pathComment == null || pathComment.isEmpty()) {
            return null;
        }
        if (sectionKey == null) {
            return pathComment.get(null);
        }
        for (Map.Entry<String, String> entry : pathComment.entrySet()) {
            if (entry.getKey() == null) continue;
            if (Objects.equals(entry.getKey(), sectionKey)) {
                return entry.getValue();
            }
            Pattern pattern = Pattern.compile(entry.getKey().replace(".", "\\.").replace("*", "(.*)"));
            if (!pattern.matcher(sectionKey).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static List<String> getHeaderComments(@NotNull ConfigurationHolder<?> holder, @Nullable String path) {
        return holder.metadata(path).get(CommentableMeta.HEADER);
    }

    @Nullable
    public static List<String> getFooterComments(@NotNull ConfigurationHolder<?> holder, @Nullable String path) {
        return holder.metadata(path).get(CommentableMeta.FOOTER);
    }
}

