/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.commentable;

import com.artformgames.plugin.residencelist.lib.configuration.annotation.FooterComments;
import com.artformgames.plugin.residencelist.lib.configuration.annotation.HeaderComments;
import com.artformgames.plugin.residencelist.lib.configuration.annotation.InlineComment;
import com.artformgames.plugin.residencelist.lib.configuration.annotation.InlineComments;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.loader.ConfigurationInitializer;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface CommentableMeta {
    public static final ConfigurationMetadata<List<String>> HEADER = ConfigurationMetadata.of(Collections.emptyList());
    public static final ConfigurationMetadata<List<String>> FOOTER = ConfigurationMetadata.of(Collections.emptyList());
    public static final ConfigurationMetadata<Map<String, String>> INLINE = ConfigurationMetadata.of();

    public static void register(@NotNull ConfigurationHolder<?> provider) {
        CommentableMeta.register(provider.initializer());
    }

    public static void register(@NotNull ConfigurationInitializer initializer) {
        initializer.registerAnnotation(HeaderComments.class, HEADER, a -> Arrays.asList(a.value()));
        initializer.registerAnnotation(FooterComments.class, FOOTER, a -> Arrays.asList(a.value()));
        initializer.registerAnnotation(InlineComment.class, INLINE, a -> {
            HashMap<String, String> map = new HashMap<String, String>();
            if (a.regex().length == 0) {
                map.put(null, a.value());
                return map;
            }
            for (String regex : a.regex()) {
                map.put(regex, a.value());
            }
            return map;
        });
        initializer.registerAnnotation(InlineComments.class, INLINE, a -> {
            HashMap<String, String> map = new HashMap<String, String>();
            for (InlineComment comment : a.value()) {
                if (comment.regex().length == 0) {
                    map.put(null, comment.value());
                    continue;
                }
                for (String regex : comment.regex()) {
                    map.put(regex, comment.value());
                }
            }
            return map;
        });
    }
}

