/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.function;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface DataFunction<T, R> {
    @NotNull
    public R handle(@NotNull T var1) throws Exception;

    @NotNull
    default public <V> DataFunction<T, V> andThen(@NotNull DataFunction<? super R, V> after) {
        Objects.requireNonNull(after);
        return data -> after.handle((R)this.handle(data));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> DataFunction<T, T> identity() {
        return input -> input;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> DataFunction<T, T> identity(Class<T> type) {
        return input -> input;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> DataFunction<T, V> required() {
        return input -> {
            throw new IllegalArgumentException("Please specify the value parser.");
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> DataFunction<T, Object> toObject() {
        return input -> input;
    }

    @Contract(pure=true)
    @NotNull
    public static <V> DataFunction<Object, V> castObject(Class<V> valueClass) {
        return input -> {
            if (valueClass.isInstance(input)) {
                return valueClass.cast(input);
            }
            throw new IllegalArgumentException("Cannot cast value to " + valueClass.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <V> DataFunction<String, V> castFromString(Class<V> valueClass) {
        return input -> {
            if (valueClass.isInstance(input)) {
                return valueClass.cast(input);
            }
            throw new IllegalArgumentException("Cannot cast string to " + valueClass.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> DataFunction<T, String> castToString() {
        return input -> {
            if (input instanceof String) {
                return (String)input;
            }
            if (input instanceof Enum) {
                return ((Enum)input).name();
            }
            return input.toString();
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <V> DataFunction<String, V> parseString(Class<V> valueClass) {
        return input -> {
            if (valueClass.isInstance(input)) {
                return valueClass.cast(input);
            }
            throw new IllegalArgumentException("Cannot cast string to " + valueClass.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static DataFunction<Object, Integer> intValue() {
        return input -> {
            if (input instanceof Integer) {
                return (Integer)input;
            }
            if (input instanceof Number) {
                return ((Number)input).intValue();
            }
            throw new IllegalArgumentException("Cannot cast value to " + Integer.class.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static DataFunction<Object, Short> shortValue() {
        return input -> {
            if (input instanceof Short) {
                return (Short)input;
            }
            if (input instanceof Number) {
                return ((Number)input).shortValue();
            }
            throw new IllegalArgumentException("Cannot cast value to " + Short.class.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static DataFunction<Object, Double> doubleValue() {
        return input -> {
            if (input instanceof Double) {
                return (Double)input;
            }
            if (input instanceof Number) {
                return ((Number)input).doubleValue();
            }
            throw new IllegalArgumentException("Cannot cast value to " + Double.class.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static DataFunction<Object, Byte> byteValue() {
        return input -> {
            if (input instanceof Byte) {
                return (Byte)input;
            }
            if (input instanceof Number) {
                return ((Number)input).byteValue();
            }
            throw new IllegalArgumentException("Cannot cast value to " + Byte.class.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static DataFunction<Object, Float> floatValue() {
        return input -> {
            if (input instanceof Float) {
                return (Float)input;
            }
            if (input instanceof Number) {
                return Float.valueOf(((Number)input).floatValue());
            }
            throw new IllegalArgumentException("Cannot cast value to " + Float.class.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static DataFunction<Object, Long> longValue() {
        return input -> {
            if (input instanceof Long) {
                return (Long)input;
            }
            if (input instanceof Number) {
                return ((Number)input).longValue();
            }
            throw new IllegalArgumentException("Cannot cast value to " + Long.class.getName());
        };
    }

    @Contract(pure=true)
    @NotNull
    public static DataFunction<Object, Boolean> booleanValue() {
        return input -> {
            if (input instanceof Boolean) {
                return (Boolean)input;
            }
            if (input instanceof String) {
                String s = (String)input;
                return Boolean.parseBoolean(s) || "yes".equalsIgnoreCase(s);
            }
            if (input instanceof Integer) {
                return (Integer)input == 1;
            }
            throw new IllegalArgumentException("Cannot cast value to " + Boolean.class.getName());
        };
    }
}

