/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.function;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ValueHandler<T, R> {
    @Nullable
    public R handle(@NotNull ConfigurationHolder<?> var1, @NotNull T var2) throws Exception;

    default public <V> ValueHandler<T, V> andThen(@NotNull ValueHandler<R, V> after) {
        Objects.requireNonNull(after);
        return (provider, data) -> {
            R result = this.handle(provider, data);
            if (result == null) {
                return null;
            }
            return after.handle(provider, result);
        };
    }

    default public <V> ValueHandler<V, R> compose(@NotNull ValueHandler<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return (provider, data) -> {
            R result = before.handle(provider, (Object)data);
            if (result == null) {
                return null;
            }
            return this.handle(provider, result);
        };
    }

    default public <V> ValueHandler<V, R> compose(@NotNull DataFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return (provider, data) -> {
            Object result = before.handle((Object)data);
            return this.handle(provider, result);
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> ValueHandler<T, T> identity() {
        return (provider, input) -> input;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> ValueHandler<T, Object> toObject() {
        return ConfigurationHolder::serialize;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> ValueHandler<T, String> stringValue() {
        return (provider, input) -> String.valueOf(input);
    }

    @Contract(pure=true)
    @NotNull
    public static <O, T> ValueHandler<O, T> deserialize(ValueType<T> to) {
        return (provider, input) -> provider.deserialize(to, input);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> ValueHandler<T, V> required() {
        return (provider, input) -> {
            throw new IllegalArgumentException("Please specify the value parser.");
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> ValueHandler<T, V> required(ValueType<V> type) {
        return (provider, input) -> {
            if (type.isInstance(input)) {
                return type.cast(input);
            }
            throw new IllegalArgumentException("Please specify the value parser.");
        };
    }
}

