/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.function;

import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ValueValidator<T> {
    public void validate(@NotNull ConfigurationHolder<?> var1, @Nullable T var2) throws Exception;

    default public ValueValidator<T> and(ValueValidator<? super T> other) {
        return (holder, value) -> {
            this.validate(holder, value);
            other.validate(holder, value);
        };
    }

    public static <V> ValueValidator<V> none() {
        return (holder, data) -> {};
    }

    public static <V> ValueValidator<V> nonnull() {
        return ValueValidator.nonnull("Value cannot be null");
    }

    public static <V> ValueValidator<V> nonnull(String message) {
        return (holder, data) -> {
            if (data == null) {
                throw new IllegalArgumentException(message);
            }
        };
    }

    public static <V extends Number> ValueValidator<V> range(V min, V max) {
        return ValueValidator.range(min, max, "Value must be in range [" + min + ", " + max + "]");
    }

    public static <V extends Number> ValueValidator<V> range(V min, V max, String message) {
        return (holder, data) -> {
            if (data.doubleValue() < min.doubleValue() || data.doubleValue() > max.doubleValue()) {
                throw new IllegalArgumentException(message);
            }
        };
    }
}

