/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.source;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapterRegistry;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueParser;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueSerializer;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.strandard.StandardAdapters;
import com.artformgames.plugin.residencelist.lib.configuration.function.ConfigExceptionHandler;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueValidator;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.loader.ConfigurationInitializer;
import com.artformgames.plugin.residencelist.lib.configuration.source.loader.PathGenerator;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetaHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetadata;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.ConfigurationOption;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.ConfigurationOptionHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSource;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationFactory<SOURCE extends ConfigureSource<?, ?, SOURCE>, HOLDER extends ConfigurationHolder<SOURCE>, SELF> {
    @NotNull
    protected ValueAdapterRegistry adapters = new ValueAdapterRegistry();
    @NotNull
    protected ConfigurationOptionHolder options = new ConfigurationOptionHolder();
    @NotNull
    protected Map<String, ConfigurationMetaHolder> metadata = new HashMap<String, ConfigurationMetaHolder>();
    @NotNull
    protected ConfigurationInitializer initializer = new ConfigurationInitializer();
    @NotNull
    protected ConfigExceptionHandler exceptionHandler = ConfigExceptionHandler.print();

    protected ConfigurationFactory() {
        this.adapters.register(StandardAdapters.PRIMITIVES);
        this.adapters.register(StandardAdapters.SECTIONS);
        this.adapters.register(StandardAdapters.ENUMS);
        this.adapters.register(StandardAdapters.UUID);
    }

    protected abstract SELF self();

    public SELF adapters(ValueAdapterRegistry adapters) {
        this.adapters = adapters;
        return this.self();
    }

    public SELF adapter(Consumer<ValueAdapterRegistry> adapterRegistryConsumer) {
        adapterRegistryConsumer.accept(this.adapters);
        return this.self();
    }

    public <T> SELF adapter(@NotNull ValueAdapter<T> adapter) {
        return this.adapter((ValueAdapterRegistry a) -> a.register(adapter));
    }

    public <T> SELF adapter(@NotNull ValueType<T> type, @NotNull ValueSerializer<T> serializer) {
        return this.adapter((ValueAdapterRegistry a) -> a.register(type, serializer));
    }

    public <T> SELF adapter(@NotNull ValueType<T> type, @NotNull ValueParser<T> parser) {
        return this.adapter((ValueAdapterRegistry a) -> a.register(type, parser));
    }

    public <FROM, TO> SELF adapter(@NotNull Class<FROM> from, @NotNull Class<TO> to, @NotNull DataFunction<FROM, TO> parser, @NotNull DataFunction<TO, FROM> serializer) {
        return this.adapter((ValueAdapterRegistry a) -> a.register(from, to, parser, serializer));
    }

    public <FROM, TO> SELF adapter(@NotNull ValueType<FROM> from, @NotNull ValueType<TO> to, @NotNull DataFunction<FROM, TO> parser, @NotNull DataFunction<TO, FROM> serializer) {
        return this.adapter((ValueAdapterRegistry a) -> a.register(from, to, parser, serializer));
    }

    public <T> SELF adapter(@NotNull ValueType<T> type, @NotNull ValueSerializer<T> serializer, @NotNull ValueParser<T> parser) {
        return this.adapter((ValueAdapterRegistry a) -> a.register(type, serializer, parser));
    }

    public <T> SELF adapter(@NotNull Class<T> type, @NotNull ValueSerializer<T> serializer, @NotNull ValueParser<T> parser) {
        return this.adapter(ValueType.of(type), serializer, parser);
    }

    public SELF options(ConfigurationOptionHolder options) {
        this.options = options;
        return this.self();
    }

    public SELF option(Consumer<ConfigurationOptionHolder> modifier) {
        modifier.accept(this.options);
        return this.self();
    }

    public <O> SELF option(ConfigurationOption<O> type, O value) {
        return this.option(o -> o.set(type, value));
    }

    public <O> SELF option(ConfigurationOption<O> type, Supplier<O> value) {
        return this.option(type, value.get());
    }

    public <O> SELF option(ConfigurationOption<O> type, Consumer<O> modifier) {
        return this.option(holder -> {
            Object current = holder.get(type);
            modifier.accept(current);
            holder.set(type, current);
        });
    }

    public SELF metadata(@NotNull Map<String, ConfigurationMetaHolder> metadata) {
        this.metadata = metadata;
        return this.self();
    }

    public SELF metadata(@NotNull Consumer<Map<String, ConfigurationMetaHolder>> handler) {
        handler.accept(this.metadata);
        return this.self();
    }

    public SELF metadata(@Nullable String path, @NotNull ConfigurationMetaHolder meta) {
        return this.metadata((Map<String, ConfigurationMetaHolder> m) -> m.put(path, meta));
    }

    public SELF metadata(@Nullable String path, @NotNull Consumer<ConfigurationMetaHolder> handler) {
        return this.metadata((Map<String, ConfigurationMetaHolder> map) -> {
            ConfigurationMetaHolder meta = map.computeIfAbsent(path, k -> new ConfigurationMetaHolder());
            handler.accept(meta);
        });
    }

    public SELF initializer(ConfigurationInitializer initializer) {
        this.initializer = initializer;
        return this.self();
    }

    public SELF initializer(Consumer<ConfigurationInitializer> initializerConsumer) {
        initializerConsumer.accept(this.initializer);
        return this.self();
    }

    public SELF exceptionally(@NotNull ConfigExceptionHandler handler) {
        this.exceptionHandler = handler;
        return this.self();
    }

    public SELF pathGenerator(PathGenerator generator) {
        return this.initializer((ConfigurationInitializer loader) -> loader.pathGenerator(generator));
    }

    public <M, A extends Annotation> SELF metaAnnotation(@NotNull Class<A> annotation, @NotNull ConfigurationMetadata<M> metadata, @NotNull Function<A, M> extractor) {
        return this.initializer((ConfigurationInitializer loader) -> loader.registerAnnotation(annotation, metadata, extractor));
    }

    public <A extends Annotation> SELF validAnnotation(@NotNull Class<A> annotation, @NotNull Function<A, ValueValidator<Object>> builder) {
        return this.initializer((ConfigurationInitializer loader) -> loader.registerValidAnnotation(annotation, builder));
    }

    @NotNull
    public abstract HOLDER build();
}

