/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.source;

import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapterRegistry;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.function.ConfigExceptionHandler;
import com.artformgames.plugin.residencelist.lib.configuration.source.loader.ConfigurationInitializer;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetaHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetadata;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.StandardMeta;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.ConfigurationOption;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.ConfigurationOptionHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSource;
import com.artformgames.plugin.residencelist.lib.configuration.value.ConfigValue;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class ConfigurationHolder<SOURCE extends ConfigureSource<?, ?, SOURCE>> {
    @NotNull
    protected final ValueAdapterRegistry adapters;
    @NotNull
    protected final ConfigurationOptionHolder options;
    @NotNull
    protected final Map<String, ConfigurationMetaHolder> metadata;
    @NotNull
    protected final ConfigurationInitializer initializer;
    @NotNull
    protected ConfigExceptionHandler exceptionHandler;

    public ConfigurationHolder(@NotNull ValueAdapterRegistry adapters, @NotNull ConfigurationOptionHolder options, @NotNull Map<String, ConfigurationMetaHolder> metadata, @NotNull ConfigurationInitializer initializer) {
        this(adapters, options, metadata, initializer, ConfigExceptionHandler.print());
    }

    public ConfigurationHolder(@NotNull ValueAdapterRegistry adapters, @NotNull ConfigurationOptionHolder options, @NotNull Map<String, ConfigurationMetaHolder> metadata, @NotNull ConfigurationInitializer initializer, @NotNull ConfigExceptionHandler exceptionHandler) {
        this.initializer = initializer;
        this.adapters = adapters;
        this.options = options;
        this.metadata = metadata;
        this.exceptionHandler = exceptionHandler;
    }

    @NotNull
    public abstract SOURCE config();

    public void reload() throws Exception {
        ((ConfigureSource)this.config()).reload();
    }

    public void save() throws Exception {
        ((ConfigureSource)this.config()).save();
    }

    public ConfigurationOptionHolder options() {
        return this.options;
    }

    @NotNull
    public <O> O option(@NotNull ConfigurationOption<O> option) {
        return this.options().get(option);
    }

    @NotNull
    public Map<String, ConfigurationMetaHolder> metadata() {
        return this.metadata;
    }

    @NotNull
    public ConfigurationMetaHolder metadata(@Nullable String path) {
        return this.metadata().computeIfAbsent(path, k -> new ConfigurationMetaHolder());
    }

    @NotNull
    public <M> @UnmodifiableView Map<String, M> extractMetadata(@NotNull ConfigurationMetadata<M> type) {
        return this.extractMetadata(type, Objects::nonNull);
    }

    @NotNull
    public <M> @UnmodifiableView Map<String, M> extractMetadata(@NotNull ConfigurationMetadata<M> type, @NotNull Predicate<@Nullable M> filter) {
        LinkedHashMap<String, M> metas = new LinkedHashMap<String, M>();
        for (Map.Entry<String, ConfigurationMetaHolder> entry : this.metadata.entrySet()) {
            M data = entry.getValue().get(type);
            if (!filter.test(data)) continue;
            metas.put(entry.getKey(), data);
        }
        return Collections.unmodifiableMap(metas);
    }

    @NotNull
    public @UnmodifiableView Map<String, ConfigValue<?, ?>> registeredValues() {
        return this.extractMetadata(StandardMeta.VALUE);
    }

    public ValueAdapterRegistry adapters() {
        return this.adapters;
    }

    public ConfigurationInitializer initializer() {
        return this.initializer;
    }

    @Nullable
    public <T> T deserialize(@NotNull Class<T> type, @Nullable Object source) throws Exception {
        return this.adapters().deserialize(this, type, source);
    }

    @Nullable
    public <T> T deserialize(@NotNull ValueType<T> type, @Nullable Object source) throws Exception {
        return this.adapters().deserialize(this, type, source);
    }

    @Nullable
    public <T> Object serialize(@Nullable T value) throws Exception {
        return this.adapters().serialize(this, value);
    }

    public void initialize(Class<? extends Configuration> configClass) {
        try {
            this.initializer.initialize(this, configClass);
        }
        catch (Exception e) {
            this.throwing(configClass.getName(), e);
        }
    }

    public void initialize(@NotNull Configuration config) {
        try {
            this.initializer.initialize(this, config);
        }
        catch (Exception e) {
            this.throwing(config.getClass().getName(), e);
        }
    }

    public void initialize(@NotNull ValueManifest<?, ?> value) {
        value.holder(this);
    }

    public void throwing(@NotNull String path, @NotNull Throwable e) {
        this.exceptionHandler.handle(path, e);
    }

    public void exceptionally(@NotNull ConfigExceptionHandler handler) {
        this.exceptionHandler = handler;
    }
}

