/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.source.file;

import com.artformgames.plugin.residencelist.lib.configuration.function.DataConsumer;
import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.FileConfigOptions;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileConfigSource<SECTION extends ConfigureSection, ORIGINAL, SELF extends FileConfigSource<SECTION, ORIGINAL, SELF>>
extends ConfigureSource<SECTION, ORIGINAL, SELF> {
    @NotNull
    protected final File file;
    @Nullable
    protected final String resourcePath;

    protected FileConfigSource(@NotNull ConfigurationHolder<? extends SELF> holder, long lastUpdateMillis, @NotNull File file, @Nullable String resourcePath) {
        super(holder, lastUpdateMillis);
        this.file = file;
        this.resourcePath = resourcePath;
    }

    public Charset charset() {
        return this.holder().options().get(FileConfigOptions.CHARSET);
    }

    public boolean copyDefaults() {
        return this.holder().options().get(FileConfigOptions.COPY_DEFAULTS);
    }

    public void initializeFile() throws IOException {
        if (this.file.exists()) {
            return;
        }
        File parent = this.file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + this.file.getParentFile().getAbsolutePath());
        }
        if (this.resourcePath != null && this.copyDefaults()) {
            try {
                this.saveResource(this.resourcePath, false);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        if (!this.file.exists() && !this.file.createNewFile()) {
            throw new IOException("Failed to create file " + this.file.getAbsolutePath());
        }
    }

    protected <R> R fileInputStream(@NotNull DataFunction<InputStream, R> loader) throws Exception {
        try (InputStream is = Files.newInputStream(this.file.toPath(), new OpenOption[0]);){
            R r = loader.handle(is);
            return r;
        }
    }

    protected <R> R fileReader(@NotNull DataFunction<Reader, R> loader) throws Exception {
        try (InputStream is = Files.newInputStream(this.file.toPath(), new OpenOption[0]);){
            R r;
            try (InputStreamReader r2 = new InputStreamReader(is, this.charset());){
                r = loader.handle(r2);
            }
            return r;
        }
    }

    protected <R> R fileReadString(@NotNull DataFunction<String, R> loader) throws Exception {
        try (InputStream is = Files.newInputStream(this.file.toPath(), new OpenOption[0]);){
            R r;
            try (InputStreamReader r2 = new InputStreamReader(is, this.charset());){
                int len;
                StringBuilder sb = new StringBuilder();
                char[] buf = new char[1024];
                while ((len = r2.read(buf)) > 0) {
                    sb.append(buf, 0, len);
                }
                r = loader.handle(sb.toString());
            }
            return r;
        }
    }

    protected void fileReadString(@NotNull DataConsumer<String> loader) throws Exception {
        try (InputStream is = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
             InputStreamReader r = new InputStreamReader(is, this.charset());){
            int len;
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[1024];
            while ((len = r.read(buf)) > 0) {
                sb.append(buf, 0, len);
            }
            loader.accept(sb.toString());
        }
    }

    protected void fileOutputStream(@NotNull DataConsumer<OutputStream> stream) throws Exception {
        try (OutputStream os = Files.newOutputStream(this.file.toPath(), new OpenOption[0]);){
            stream.accept(os);
        }
    }

    protected void fileWriter(@NotNull DataConsumer<Writer> writer) throws Exception {
        try (OutputStream os = Files.newOutputStream(this.file.toPath(), new OpenOption[0]);
             OutputStreamWriter w = new OutputStreamWriter(os, this.charset());){
            writer.accept(w);
        }
    }

    protected void saveResource(@NotNull String resourcePath, boolean replace) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(resourcePath, "ResourcePath cannot be null");
        if (resourcePath.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be empty");
        }
        resourcePath = resourcePath.replace('\\', '/');
        URL url = this.getClass().getClassLoader().getResource(resourcePath);
        if (url == null) {
            throw new IllegalArgumentException("The resource '" + resourcePath + "' not exists");
        }
        File outDir = this.file.getParentFile();
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IOException("Failed to create directory " + outDir);
        }
        if (!this.file.exists() || replace) {
            try (OutputStream out = Files.newOutputStream(this.file.toPath(), new OpenOption[0]);){
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                try (InputStream in = connection.getInputStream();){
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
            }
        }
    }

    @Nullable
    protected InputStream getResource(@NotNull String filename) {
        try {
            URL url = this.getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

