/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.source.loader;

import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueValidator;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.loader.ConfigInitializeHandler;
import com.artformgames.plugin.residencelist.lib.configuration.source.loader.PathGenerator;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetadata;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.StandardMeta;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.StandardOptions;
import com.artformgames.plugin.residencelist.lib.configuration.value.ConfigValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationInitializer {
    @NotNull
    protected PathGenerator pathGenerator;
    @NotNull
    protected ConfigInitializeHandler<Field, ConfigValue<?, ?>> valueInitializer;
    @NotNull
    protected ConfigInitializeHandler<Class<? extends Configuration>, Object> classInitializer;

    public ConfigurationInitializer() {
        this(PathGenerator.of(), ConfigInitializeHandler.start(), ConfigInitializeHandler.start());
    }

    public ConfigurationInitializer(@NotNull PathGenerator pathGenerator, @NotNull ConfigInitializeHandler<Field, ConfigValue<?, ?>> valueInitializer, @NotNull ConfigInitializeHandler<Class<? extends Configuration>, Object> classInitializer) {
        this.pathGenerator = pathGenerator;
        this.valueInitializer = valueInitializer;
        this.classInitializer = classInitializer;
    }

    public void pathGenerator(@NotNull PathGenerator pathGenerator) {
        this.pathGenerator = pathGenerator;
    }

    @NotNull
    public PathGenerator pathGenerator() {
        return this.pathGenerator;
    }

    public ConfigInitializeHandler<Field, ConfigValue<?, ?>> fieldInitializer() {
        return this.valueInitializer;
    }

    public void fieldInitializer(@NotNull ConfigInitializeHandler<Field, ConfigValue<?, ?>> fieldInitializer) {
        this.valueInitializer = fieldInitializer;
    }

    public ConfigInitializeHandler<Class<? extends Configuration>, Object> classInitializer() {
        return this.classInitializer;
    }

    public void classInitializer(@NotNull ConfigInitializeHandler<Class<? extends Configuration>, Object> classInitializer) {
        this.classInitializer = classInitializer;
    }

    public void appendFieldInitializer(@NotNull ConfigInitializeHandler<Field, ConfigValue<?, ?>> fieldInitializer) {
        this.valueInitializer = this.valueInitializer.andThen(fieldInitializer);
    }

    public void appendClassInitializer(@NotNull ConfigInitializeHandler<Class<? extends Configuration>, Object> classInitializer) {
        this.classInitializer = this.classInitializer.andThen(classInitializer);
    }

    public <T, A extends Annotation> void registerClassAnnotation(@NotNull Class<A> annotation, @NotNull ConfigurationMetadata<T> metadata, @NotNull Function<A, T> extractor) {
        this.appendClassInitializer((holder, path, clazz, instance) -> {
            Object data = clazz.getAnnotation(annotation);
            if (data == null) {
                return;
            }
            holder.metadata(path).setIfAbsent(metadata, extractor.apply(data));
        });
    }

    public <T, A extends Annotation> void registerFieldAnnotation(@NotNull Class<A> annotation, @NotNull ConfigurationMetadata<T> metadata, @NotNull Function<A, T> extractor) {
        this.appendFieldInitializer((holder, path, field, instance) -> {
            Object data = field.getAnnotation(annotation);
            if (data == null) {
                return;
            }
            holder.metadata(path).setIfAbsent(metadata, extractor.apply(data));
        });
    }

    public <T, A extends Annotation> void registerAnnotation(@NotNull Class<A> annotation, @NotNull ConfigurationMetadata<T> metadata, @NotNull Function<A, T> extractor) {
        this.registerClassAnnotation(annotation, metadata, extractor);
        this.registerFieldAnnotation(annotation, metadata, extractor);
    }

    public <A extends Annotation> void registerValidAnnotation(@NotNull Class<A> annotation, @NotNull Function<A, ValueValidator<Object>> builder) {
        this.appendFieldInitializer((holder, path, field, instance) -> {
            Object data = field.getAnnotation(annotation);
            if (data == null) {
                return;
            }
            instance.validate((h, t) -> ((ValueValidator)builder.apply(data)).validate(h, t));
        });
    }

    @Nullable
    public String getFieldPath(@NotNull ConfigurationHolder<?> holder, @Nullable String parentPath, @NotNull Field field) {
        return this.pathGenerator.getFieldPath(holder, parentPath, field);
    }

    @Nullable
    public String getClassPath(@NotNull ConfigurationHolder<?> holder, @Nullable String parentPath, @NotNull Class<?> clazz, @Nullable Field clazzField) {
        return this.pathGenerator.getClassPath(holder, parentPath, clazz, clazzField);
    }

    public void initialize(@NotNull ConfigurationHolder<?> holder, @NotNull Configuration config) throws Exception {
        this.initializeInstance(holder, config, null, null);
        if (holder.option(StandardOptions.SET_DEFAULTS).booleanValue()) {
            holder.save();
        }
    }

    public void initialize(@NotNull ConfigurationHolder<?> holder, @NotNull Class<? extends Configuration> clazz) throws Exception {
        this.initializeStaticClass(holder, clazz, null, null);
        if (holder.option(StandardOptions.SET_DEFAULTS).booleanValue()) {
            holder.save();
        }
    }

    protected void initializeInstance(@NotNull ConfigurationHolder<?> holder, @NotNull Configuration root, @Nullable String parentPath, @Nullable Field configField) {
        String path = this.getClassPath(holder, parentPath, root.getClass(), configField);
        try {
            this.classInitializer.whenInitialize(holder, path, root.getClass(), root);
        }
        catch (Exception e) {
            holder.throwing(path, e);
        }
        Arrays.stream(root.getClass().getDeclaredFields()).forEach(field -> this.initializeField(holder, root, (Field)field, path));
    }

    protected void initializeStaticClass(@NotNull ConfigurationHolder<?> holder, @NotNull Class<?> clazz, @Nullable String parentPath, @Nullable Field configField) {
        if (!Configuration.class.isAssignableFrom(clazz)) {
            return;
        }
        String path = this.getClassPath(holder, parentPath, clazz, configField);
        try {
            this.classInitializer.whenInitialize(holder, path, clazz, configField);
        }
        catch (Exception e) {
            holder.throwing(path, e);
        }
        for (Field field : clazz.getDeclaredFields()) {
            this.initializeField(holder, clazz, field, path);
        }
        if (holder.option(StandardOptions.LOAD_SUB_CLASSES).booleanValue()) {
            Class<?>[] classes = clazz.getDeclaredClasses();
            for (int i = classes.length - 1; i >= 0; --i) {
                this.initializeStaticClass(holder, classes[i], path, null);
            }
        }
    }

    protected void initializeField(@NotNull ConfigurationHolder<?> holder, @NotNull Object source, @NotNull Field field, @Nullable String parent) {
        block11: {
            try {
                field.setAccessible(true);
                Object object = field.get(source);
                if (object instanceof ConfigValue) {
                    ConfigValue value = (ConfigValue)object;
                    String path = this.getFieldPath(holder, parent, field);
                    if (path == null) {
                        return;
                    }
                    value.initialize(holder, path);
                    holder.metadata(path).set(StandardMeta.VALUE, value);
                    if (holder.option(StandardOptions.SET_DEFAULTS).booleanValue()) {
                        value.setDefault();
                    }
                    try {
                        this.valueInitializer.whenInitialize(holder, path, field, value);
                    }
                    catch (Exception e) {
                        holder.throwing(path, e);
                    }
                    if (holder.option(StandardOptions.PRELOAD).booleanValue()) {
                        value.get();
                    }
                    break block11;
                }
                if (source instanceof Configuration && object instanceof Configuration) {
                    this.initializeInstance(holder, (Configuration)object, parent, field);
                } else if (source instanceof Class && object instanceof Class) {
                    this.initializeStaticClass(holder, (Class)object, parent, field);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

