/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.source.loader;

import com.artformgames.plugin.residencelist.lib.configuration.annotation.ConfigPath;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.StandardOptions;
import java.lang.reflect.Field;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathGenerator {
    protected UnaryOperator<String> pathConverter;

    public static PathGenerator of() {
        return PathGenerator.of(PathGenerator::covertPathName);
    }

    public static PathGenerator of(UnaryOperator<String> pathConverter) {
        return new PathGenerator(pathConverter);
    }

    public PathGenerator(UnaryOperator<String> pathConverter) {
        this.pathConverter = pathConverter;
    }

    @NotNull
    public UnaryOperator<String> getPathConverter() {
        return this.pathConverter;
    }

    public void setPathConverter(UnaryOperator<String> pathConverter) {
        this.pathConverter = pathConverter;
    }

    public String covertPath(String name) {
        return (String)this.pathConverter.apply(name);
    }

    @Nullable
    public String getFieldPath(@NotNull ConfigurationHolder<?> holder, @Nullable String parentPath, @NotNull Field field) {
        ConfigPath path = field.getAnnotation(ConfigPath.class);
        if (path == null) {
            return this.link(holder, parentPath, false, this.covertPath(field.getName()));
        }
        return this.link(holder, parentPath, path.root(), this.select(path.value(), this.covertPath(field.getName())));
    }

    @Nullable
    public String getClassPath(@NotNull ConfigurationHolder<?> holder, @Nullable String parentPath, @NotNull Class<?> clazz, @Nullable Field clazzField) {
        ConfigPath clazzPath = clazz.getAnnotation(ConfigPath.class);
        if (clazzPath != null) {
            return this.link(holder, parentPath, clazzPath.root(), clazzPath.value());
        }
        if (clazzField != null) {
            ConfigPath fieldPath = clazzField.getAnnotation(ConfigPath.class);
            if (fieldPath == null) {
                return this.link(holder, parentPath, false, this.covertPath(clazzField.getName()));
            }
            return this.getFieldPath(holder, parentPath, clazzField);
        }
        return this.link(holder, parentPath, false, this.covertPath(clazz.getSimpleName()));
    }

    protected String select(String path, String defaultValue) {
        if (path == null || path.isEmpty()) {
            return defaultValue;
        }
        return PathGenerator.isBlank(path) ? null : path;
    }

    @Nullable
    protected String link(@NotNull ConfigurationHolder<?> holder, @Nullable String parent, boolean root, @Nullable String path) {
        if (path == null || path.isEmpty()) {
            return root ? null : parent;
        }
        return root || parent == null ? path : parent + PathGenerator.pathSeparator(holder) + path;
    }

    public static boolean isBlank(String path) {
        return path == null || path.replace(" ", "").isEmpty();
    }

    public static char pathSeparator(ConfigurationHolder<?> holder) {
        return holder.option(StandardOptions.PATH_SEPARATOR).charValue();
    }

    public static String covertPathName(String name) {
        return name.replaceAll("[A-Z]", "=$0").replaceAll("^=(.*)$", "$1").replaceAll("_=([A-Z])", "_$1").replaceAll("([a-z])=([A-Z])", "$1_$2").replace("=", "").replace("_", "-").toLowerCase();
    }
}

