/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.source.meta;

import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetadata;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationMetaHolder {
    @NotNull
    protected final Map<ConfigurationMetadata<?>, Object> values;

    public ConfigurationMetaHolder() {
        this(new ConcurrentHashMap());
    }

    public ConfigurationMetaHolder(@NotNull Map<ConfigurationMetadata<?>, Object> values) {
        this.values = values;
    }

    @NotNull
    public Map<ConfigurationMetadata<?>, Object> values() {
        return this.values;
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public <V> V get(@NotNull ConfigurationMetadata<V> type, @Nullable V defaultValue) {
        return (V)this.values().getOrDefault(type, type.defaultOrSupply(defaultValue));
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public <V> V get(@NotNull ConfigurationMetadata<V> type, Supplier<@Nullable V> defaultValue) {
        return (V)this.values().getOrDefault(type, type.defaultOrSupply(defaultValue));
    }

    @Nullable
    public <V> V get(@NotNull ConfigurationMetadata<V> type) {
        return this.get(type, (V)null);
    }

    public boolean contains(@NotNull ConfigurationMetadata<?> type) {
        return this.values().containsKey(type) || type.hasDefaults();
    }

    @Nullable
    public <V> V set(@NotNull ConfigurationMetadata<V> type, @Nullable V value) {
        if (value == null || type.isDefault(value)) {
            return (V)this.values().remove(type);
        }
        return (V)this.values().put(type, value);
    }

    public <V> void setIfAbsent(@NotNull ConfigurationMetadata<V> type, @Nullable V value) {
        if (value == null || type.isDefault(value)) {
            this.values().remove(type);
        } else {
            this.values().putIfAbsent(type, value);
        }
    }

    @Nullable
    public <V> V setIfPresent(@NotNull ConfigurationMetadata<V> type, @Nullable V value) {
        Object exists = this.values().get(type);
        if (exists == null) {
            return null;
        }
        if (value == null || type.isDefault(value)) {
            return (V)this.values().remove(type);
        }
        return (V)this.values().put(type, value);
    }
}

