/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.source.section;

import com.artformgames.plugin.residencelist.lib.configuration.function.DataFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface ConfigureSection {
    @Contract(pure=true)
    @Nullable
    public ConfigureSection parent();

    @NotNull
    public String path();

    @NotNull
    default public String fullPath() {
        if (this.parent() == null) {
            return "";
        }
        return (this.parent().isRoot() ? "" : this.parent().fullPath() + this.pathSeparator()) + this.path();
    }

    default public char pathSeparator() {
        return '.';
    }

    @Contract(pure=true)
    default public boolean isRoot() {
        return this.parent() == null;
    }

    default public boolean isEmpty() {
        return this.getValues(false).isEmpty();
    }

    default public int size(boolean deep) {
        return this.getKeys(deep).size();
    }

    @NotNull
    default public @UnmodifiableView Set<String> getKeys(boolean deep) {
        return this.getValues(deep).keySet();
    }

    @NotNull
    default public @UnmodifiableView Set<String> keys() {
        return this.getKeys(false);
    }

    @NotNull
    public @UnmodifiableView Map<String, Object> getValues(boolean var1);

    @NotNull
    default public @UnmodifiableView Map<String, Object> values() {
        return this.getValues(false);
    }

    @NotNull
    public @UnmodifiableView Map<String, Object> asMap();

    default public Stream<Map.Entry<String, Object>> stream() {
        return this.values().entrySet().stream();
    }

    default public void forEach(@NotNull BiConsumer<String, Object> action) {
        this.values().forEach(action);
    }

    public void set(@NotNull String var1, @Nullable Object var2);

    public void remove(@NotNull String var1);

    default public boolean contains(@NotNull String path) {
        return this.getKeys(true).contains(path);
    }

    default public boolean containsValue(@NotNull String path) {
        return this.get(path) != null;
    }

    default public <T> boolean isType(@NotNull String path, @NotNull Class<T> typeClass) {
        return typeClass.isInstance(this.get(path));
    }

    default public boolean isList(@NotNull String path) {
        return this.isType(path, List.class);
    }

    @Nullable
    default public List<?> getList(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof List ? (List)val : null;
    }

    default public boolean isSection(@NotNull String path) {
        return this.isType(path, ConfigureSection.class);
    }

    @Nullable
    default public ConfigureSection getSection(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof ConfigureSection ? (ConfigureSection)val : null;
    }

    @NotNull
    public ConfigureSection createSection(@NotNull String var1, @NotNull Map<?, ?> var2);

    @NotNull
    default public ConfigureSection createSection(@NotNull String path, @NotNull Consumer<Map<String, Object>> data) {
        return this.createSection(path, () -> {
            LinkedHashMap map = new LinkedHashMap();
            data.accept(map);
            return map;
        });
    }

    @NotNull
    default public ConfigureSection createSection(@NotNull String path, @NotNull Supplier<Map<String, Object>> data) {
        return this.createSection(path, data.get());
    }

    @NotNull
    default public ConfigureSection createSection(@NotNull String path) {
        return this.createSection(path, new LinkedHashMap());
    }

    @NotNull
    default public ConfigureSection computeSection(@NotNull String path) {
        return this.computeSection(path, new LinkedHashMap());
    }

    @NotNull
    default public ConfigureSection computeSection(@NotNull String path, @NotNull Map<?, ?> data) {
        ConfigureSection current = this.getSection(path);
        if (current == null) {
            current = this.createSection(path, data);
            this.set(path, current);
        }
        return current;
    }

    @NotNull
    default public ConfigureSection computeSection(@NotNull String path, @NotNull Consumer<Map<String, Object>> data) {
        return this.computeSection(path, () -> {
            LinkedHashMap map = new LinkedHashMap();
            data.accept(map);
            return map;
        });
    }

    @NotNull
    default public ConfigureSection computeSection(@NotNull String path, @NotNull Supplier<Map<String, Object>> data) {
        return this.computeSection(path, data.get());
    }

    @Nullable
    public Object get(@NotNull String var1);

    @Nullable
    default public <T> T get(@NotNull String path, @NotNull Class<T> type) {
        return this.get(path, null, type);
    }

    @Nullable
    default public <T> T get(@NotNull String path, @NotNull DataFunction<@Nullable Object, T> parser) {
        return this.get(path, null, parser);
    }

    @Contract(value="_,!null,_->!null")
    @Nullable
    default public <T> T get(@NotNull String path, @Nullable T defaults, @NotNull Class<T> clazz) {
        return this.get(path, defaults, DataFunction.castObject(clazz));
    }

    @Contract(value="_,!null,_->!null")
    @Nullable
    default public <T> T get(@NotNull String path, @Nullable T defaultValue, @NotNull DataFunction<Object, T> parser) {
        Object value = this.get(path);
        if (value != null) {
            try {
                return parser.handle(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return defaultValue;
    }

    default public boolean isBoolean(@NotNull String path) {
        return this.isType(path, Boolean.class);
    }

    default public boolean getBoolean(@NotNull String path) {
        return this.getBoolean(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public Boolean getBoolean(@NotNull String path, @Nullable Boolean def) {
        return this.get(path, def, DataFunction.booleanValue());
    }

    @Nullable
    default public Boolean isByte(@NotNull String path) {
        return this.isType(path, Byte.class);
    }

    @Nullable
    default public Byte getByte(@NotNull String path) {
        return this.getByte(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public Byte getByte(@NotNull String path, @Nullable Byte def) {
        return this.get(path, def, DataFunction.byteValue());
    }

    default public boolean isShort(@NotNull String path) {
        return this.isType(path, Short.class);
    }

    @Nullable
    default public Short getShort(@NotNull String path) {
        return this.getShort(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public Short getShort(@NotNull String path, @Nullable Short def) {
        return this.get(path, def, DataFunction.shortValue());
    }

    default public boolean isInt(@NotNull String path) {
        return this.isType(path, Integer.class);
    }

    @Nullable
    default public Integer getInt(@NotNull String path) {
        return this.getInt(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public Integer getInt(@NotNull String path, @Nullable Integer def) {
        return this.get(path, def, DataFunction.intValue());
    }

    default public boolean isLong(@NotNull String path) {
        return this.isType(path, Long.class);
    }

    @Nullable
    default public Long getLong(@NotNull String path) {
        return this.getLong(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public Long getLong(@NotNull String path, @Nullable Long def) {
        return this.get(path, def, DataFunction.longValue());
    }

    default public boolean isFloat(@NotNull String path) {
        return this.isType(path, Float.class);
    }

    @Nullable
    default public Float getFloat(@NotNull String path) {
        return this.getFloat(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public Float getFloat(@NotNull String path, @Nullable Float def) {
        return this.get(path, def, DataFunction.floatValue());
    }

    default public boolean isDouble(@NotNull String path) {
        return this.isType(path, Double.class);
    }

    @Nullable
    default public Double getDouble(@NotNull String path) {
        return this.getDouble(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public Double getDouble(@NotNull String path, @Nullable Double def) {
        return this.get(path, def, DataFunction.doubleValue());
    }

    default public boolean isChar(@NotNull String path) {
        return this.isType(path, Character.class);
    }

    @Nullable
    default public Character getChar(@NotNull String path) {
        return this.getChar(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public Character getChar(@NotNull String path, @Nullable Character def) {
        return this.get(path, def, Character.class);
    }

    default public boolean isString(@NotNull String path) {
        return this.isType(path, String.class);
    }

    @Nullable
    default public String getString(@NotNull String path) {
        return this.getString(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public String getString(@NotNull String path, @Nullable String def) {
        return this.get(path, def, String.class);
    }

    @NotNull
    default public <V> List<V> getList(@NotNull String path, @NotNull DataFunction<Object, V> parser) {
        return this.getCollection(path, ArrayList::new, parser);
    }

    @NotNull
    default public List<String> getStringList(@NotNull String path) {
        return this.getList(path, DataFunction.castToString());
    }

    @NotNull
    default public List<Integer> getIntegerList(@NotNull String path) {
        return this.getList(path, DataFunction.intValue());
    }

    @NotNull
    default public List<Long> getLongList(@NotNull String path) {
        return this.getList(path, DataFunction.longValue());
    }

    @NotNull
    default public List<Double> getDoubleList(@NotNull String path) {
        return this.getList(path, DataFunction.doubleValue());
    }

    @NotNull
    default public List<Float> getFloatList(@NotNull String path) {
        return this.getList(path, DataFunction.floatValue());
    }

    @NotNull
    default public List<Byte> getByteList(@NotNull String path) {
        return this.getList(path, DataFunction.byteValue());
    }

    @NotNull
    default public List<Character> getCharList(@NotNull String path) {
        return this.getList(path, DataFunction.castObject(Character.class));
    }

    @NotNull
    default public List<ConfigureSection> getSectionList(@NotNull String path) {
        return this.getList(path, obj -> {
            if (obj instanceof ConfigureSection) {
                return (ConfigureSection)obj;
            }
            return null;
        });
    }

    @NotNull
    default public <T, C extends Collection<T>> C getCollection(@NotNull String path, @NotNull Supplier<C> constructor, @NotNull DataFunction<Object, T> parser) {
        return ConfigureSection.parseCollection(this.getList(path), constructor, parser);
    }

    @NotNull
    default public Stream<?> stream(@NotNull String path) {
        List<?> values = this.getList(path);
        return values == null ? Stream.empty() : values.stream();
    }

    @NotNull
    default public <T> Stream<T> stream(@NotNull String path, @NotNull Function<Object, T> parser) {
        return this.stream(path).map(parser);
    }

    default public String childPath(String path) {
        int index = path.indexOf(this.pathSeparator());
        return index == -1 ? path : path.substring(index + 1);
    }

    @NotNull
    public static <T, C extends Collection<T>> C parseCollection(@Nullable List<?> data, @NotNull Supplier<C> constructor, @NotNull DataFunction<Object, T> parser) {
        Collection values = (Collection)constructor.get();
        if (data == null) {
            return (C)values;
        }
        for (Object obj : data) {
            try {
                values.add(parser.handle(obj));
            }
            catch (Exception exception) {}
        }
        return (C)values;
    }
}

