/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.source.section;

import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.option.StandardOptions;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class ConfigureSource<SECTION extends ConfigureSection, ORIGINAL, SELF extends ConfigureSource<SECTION, ORIGINAL, SELF>>
implements ConfigureSection {
    @NotNull
    protected final ConfigurationHolder<? extends SELF> holder;
    protected long lastUpdateMillis;

    protected ConfigureSource(@NotNull ConfigurationHolder<? extends SELF> holder, long lastUpdateMillis) {
        this.holder = holder;
        this.lastUpdateMillis = lastUpdateMillis;
    }

    @NotNull
    public ConfigurationHolder<? extends SELF> holder() {
        return this.holder;
    }

    public void reload() throws Exception {
        this.onReload();
        this.lastUpdateMillis = System.currentTimeMillis();
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    @NotNull
    protected abstract SELF self();

    @Contract(pure=true)
    @NotNull
    public abstract ORIGINAL original();

    @NotNull
    public abstract SECTION section();

    public abstract void save() throws Exception;

    @ApiStatus.OverrideOnly
    protected abstract void onReload() throws Exception;

    @Override
    public char pathSeparator() {
        return this.holder().options().get(StandardOptions.PATH_SEPARATOR).charValue();
    }

    public long getLastUpdateMillis() {
        return this.lastUpdateMillis;
    }

    public boolean isExpired(long parsedTime) {
        return this.getLastUpdateMillis() > parsedTime;
    }

    @Override
    @Contract(pure=true, value="->null")
    @Nullable
    public ConfigureSection parent() {
        return null;
    }

    @Override
    @NotNull
    public String path() {
        return "";
    }

    @Override
    @NotNull
    public Map<String, Object> getValues(boolean deep) {
        return this.section().getValues(deep);
    }

    @Override
    @NotNull
    public @UnmodifiableView Set<String> getKeys(boolean deep) {
        return this.section().getKeys(deep);
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<String, Object> asMap() {
        return this.section().asMap();
    }

    @Override
    @NotNull
    public ConfigureSection createSection(@NotNull String path, @NotNull Map<?, ?> data) {
        return this.section().createSection(path, data);
    }

    @Override
    public void set(@NotNull String path, @Nullable Object value) {
        this.section().set(path, value);
    }

    @Override
    public void remove(@NotNull String path) {
        this.section().remove(path);
    }

    @Override
    @Nullable
    public Object get(@NotNull String path) {
        return this.section().get(path);
    }
}

