/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value;

import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T, U>
extends ValueManifest<T, U> {
    protected ConfigValue(@NotNull ValueManifest<T, U> manifest) {
        super(manifest);
    }

    @Nullable
    public abstract T get();

    public T getOrDefault() {
        return this.optional().orElse(this.defaults());
    }

    @NotNull
    public T resolve() {
        return Objects.requireNonNull(this.getOrDefault(), "Value(" + this.type() + ") @[" + this.path() + "] is null.");
    }

    @NotNull
    public T getNotNull() {
        return this.resolve();
    }

    public @NotNull Optional<@Nullable T> optional() {
        return Optional.ofNullable(this.get());
    }

    public abstract void set(@Nullable T var1);

    public void setDefault() {
        this.setDefault(false);
    }

    public void setDefault(boolean override) {
        if (this.config().contains(this.path()) && !override) {
            return;
        }
        this.set(this.defaults());
    }

    public boolean isDefault() {
        return Objects.equals(this.defaults(), this.get());
    }

    public void save() throws Exception {
        this.holder().save();
    }
}

