/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.function.ValueValidator;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.meta.ConfigurationMetaHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSource;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueManifest<TYPE, UNIT> {
    @NotNull
    protected final ValueType<TYPE> type;
    @NotNull
    protected final @NotNull BiConsumer<@NotNull ConfigurationHolder<?>, @NotNull String> initializer;
    @Nullable
    protected ConfigurationHolder<?> holder;
    @Nullable
    protected String path;
    @NotNull
    protected ValueValidator<UNIT> validator;
    protected @NotNull Supplier<@Nullable TYPE> defaultSupplier;
    @NotNull
    private static final @NotNull BiConsumer<@NotNull ConfigurationHolder<?>, @NotNull String> EMPTY_INITIALIZER = (provider, valuePath) -> {};

    public ValueManifest(@NotNull ValueType<TYPE> type) {
        this(type, () -> null, ValueValidator.none(), EMPTY_INITIALIZER, null, null);
    }

    public ValueManifest(@NotNull TYPE defaultValue) {
        this(ValueType.of(defaultValue), () -> defaultValue);
    }

    public ValueManifest(@NotNull ValueType<TYPE> type, @NotNull Supplier<@Nullable TYPE> defaultSupplier) {
        this(type, defaultSupplier, ValueValidator.none(), EMPTY_INITIALIZER, null, null);
    }

    public ValueManifest(@NotNull ValueType<TYPE> type, @NotNull Supplier<@Nullable TYPE> defaultSupplier, @NotNull ValueValidator<UNIT> validator) {
        this(type, defaultSupplier, validator, EMPTY_INITIALIZER, null, null);
    }

    public ValueManifest(@NotNull ValueType<TYPE> type, @NotNull Supplier<@Nullable TYPE> defaultSupplier, @NotNull ValueValidator<UNIT> validator, @NotNull @NotNull BiConsumer<@NotNull ConfigurationHolder<?>, @NotNull String> initializer) {
        this(type, defaultSupplier, validator, initializer, null, null);
    }

    public ValueManifest(@NotNull ValueType<TYPE> type, @NotNull Supplier<@Nullable TYPE> defaultSupplier, @NotNull ValueValidator<UNIT> validator, @NotNull @NotNull BiConsumer<@NotNull ConfigurationHolder<?>, @NotNull String> initializer, @Nullable ConfigurationHolder<?> holder, @Nullable String path) {
        this.type = type;
        this.validator = validator;
        this.initializer = initializer;
        this.defaultSupplier = defaultSupplier;
        this.holder = holder;
        this.path = path;
        this.initialize();
    }

    protected ValueManifest(@NotNull ValueManifest<TYPE, UNIT> manifest) {
        this(manifest.type, manifest.defaultSupplier, manifest.validator, manifest.initializer, manifest.holder, manifest.path);
    }

    public void initialize(@NotNull ConfigurationHolder<?> holder, @NotNull String path) {
        this.holder = holder;
        this.path = path;
        this.initialize();
    }

    protected void initialize() {
        if (this.holder != null && this.path != null) {
            this.initializer.accept(this.holder, this.path);
        }
    }

    @NotNull
    public ValueType<TYPE> type() {
        return this.type;
    }

    public void holder(@NotNull ConfigurationHolder<?> holder) {
        this.holder = holder;
    }

    public void path(@NotNull String path) {
        this.path = path;
    }

    @Nullable
    public TYPE defaults() {
        return this.defaultSupplier.get();
    }

    public void defaults(@Nullable TYPE defaultValue) {
        this.defaults(() -> defaultValue);
    }

    public void defaults(@NotNull Supplier<@Nullable TYPE> defaultValue) {
        this.defaultSupplier = defaultValue;
    }

    public boolean hasDefaults() {
        return this.defaults() != null;
    }

    @NotNull
    public ValueValidator<UNIT> validator() {
        return this.validator;
    }

    public void validator(@NotNull ValueValidator<UNIT> validator) {
        this.validator = validator;
    }

    public void validate(@NotNull ValueValidator<UNIT> validator) {
        this.validator(this.validator.and(validator));
    }

    protected UNIT withValidated(@Nullable UNIT value) throws Exception {
        this.validator.validate(this.holder(), value);
        return value;
    }

    @NotNull
    public String path() {
        if (this.path != null) {
            return this.path;
        }
        throw new IllegalStateException("No section path provided for Value(" + this.type() + ").");
    }

    @NotNull
    public ConfigurationHolder<?> holder() {
        if (this.holder != null) {
            return this.holder;
        }
        throw new IllegalStateException("Value(" + this.type() + ") does not have a provider.");
    }

    @NotNull
    public ConfigureSource<?, ?, ?> config() {
        return this.holder().config();
    }

    @NotNull
    public ConfigurationMetaHolder metadata() {
        return this.holder().metadata(this.path());
    }

    @ApiStatus.Internal
    @Nullable
    protected Object getData() {
        return this.config().get(this.path());
    }

    @ApiStatus.Internal
    protected void setData(@Nullable Object value) {
        this.config().set(this.path(), value);
    }

    protected void throwing(@NotNull Throwable throwable) {
        this.throwing(this.path, throwable);
    }

    protected void throwing(@NotNull String path, @NotNull Throwable throwable) {
        if (this.holder == null) {
            throwable.printStackTrace();
        } else {
            this.holder.throwing(path, throwable);
        }
    }
}

