/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.impl;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueParser;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueSerializer;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.value.ConfigValue;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedConfigValue<T, U>
extends ConfigValue<T, U> {
    @Nullable
    protected T cachedValue;
    protected long parsedTime = -1L;

    protected CachedConfigValue(@NotNull ValueManifest<T, U> manifest) {
        super(manifest);
    }

    protected T updateCache(T value) {
        this.parsedTime = System.currentTimeMillis();
        this.cachedValue = value;
        return this.getCachedValue();
    }

    @Nullable
    public T getCachedValue() {
        return this.cachedValue;
    }

    public boolean cacheExpired() {
        return this.parsedTime <= 0L || this.config().isExpired(this.parsedTime);
    }

    protected final T getDefaultFirst(@Nullable T value) {
        return this.updateCache(this.defaults() == null ? value : this.defaults());
    }

    @Nullable
    protected T getCachedOrDefault() {
        return this.getCachedOrDefault(null);
    }

    @Contract(value="!null->!null")
    protected T getCachedOrDefault(@Nullable T emptyValue) {
        if (this.getCachedValue() != null) {
            return this.getCachedValue();
        }
        if (this.defaults() != null) {
            return (T)this.defaults();
        }
        return emptyValue;
    }

    @Nullable
    protected <O> ValueParser<O> parserFor(@NotNull ValueAdapter<O> adapter) {
        if (adapter.parser() != null) {
            return adapter.parser();
        }
        ValueAdapter<ValueType<O>> registered = this.holder().adapters().adapterOf(adapter.type());
        if (registered == null) {
            return null;
        }
        return registered.parser();
    }

    @Nullable
    protected <O> ValueSerializer<O> serializerFor(@NotNull ValueAdapter<O> adapter) {
        if (adapter.serializer() != null) {
            return adapter.serializer();
        }
        ValueAdapter<ValueType<O>> registered = this.holder().adapters().adapterOf(adapter.type());
        if (registered == null) {
            return null;
        }
        return registered.serializer();
    }
}

