/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.standard;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueParser;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueSerializer;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.list.ConfigListBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.builder.list.SourceListBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import com.artformgames.plugin.residencelist.lib.configuration.value.impl.CachedConfigValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguredList<V>
extends CachedConfigValue<List<V>, V>
implements List<V> {
    @NotNull
    protected final Supplier<? extends List<V>> constructor;
    @NotNull
    protected final ValueAdapter<V> paramAdapter;

    @NotNull
    public static <T> ConfigListBuilder<T> builderOf(@NotNull Class<T> type) {
        return ConfiguredList.builderOf(ValueType.of(type));
    }

    @NotNull
    public static <T> ConfigListBuilder<T> builderOf(@NotNull ValueType<T> type) {
        return new ConfigListBuilder<T>(type);
    }

    @NotNull
    public static <T> SourceListBuilder<T, T> with(@NotNull Class<T> registeredType) {
        return ConfiguredList.with(ValueType.of(registeredType));
    }

    @NotNull
    public static <T> SourceListBuilder<T, T> with(@NotNull ValueType<T> registeredType) {
        return new ConfigListBuilder<T>(registeredType).from(registeredType);
    }

    @SafeVarargs
    @NotNull
    public static <T> ConfiguredList<T> of(@NotNull T value, T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(value);
        Collections.addAll(list, values);
        return ((SourceListBuilder)ConfiguredList.with(ValueType.of(value)).defaults(list)).build();
    }

    public ConfiguredList(@NotNull ValueManifest<List<V>, V> manifest, @NotNull Supplier<? extends List<V>> constructor, @NotNull ValueAdapter<V> paramAdapter) {
        super(manifest);
        this.constructor = constructor;
        this.paramAdapter = paramAdapter;
    }

    @NotNull
    public ValueAdapter<V> adapter() {
        return this.paramAdapter;
    }

    @NotNull
    public ValueType<V> paramType() {
        return this.adapter().type();
    }

    @Nullable
    public ValueParser<V> parser() {
        return this.parserFor(this.adapter());
    }

    @Nullable
    public ValueSerializer<V> serializer() {
        return this.serializerFor(this.adapter());
    }

    @NotNull
    private List<V> createList() {
        return this.constructor.get();
    }

    @Override
    @NotNull
    public List<V> get() {
        if (!this.cacheExpired()) {
            return this.getCachedOrDefault(this.createList());
        }
        List<V> list = this.createList();
        try {
            List<?> data;
            List<?> list2 = data = this.config().contains(this.path()) ? this.config().getList(this.path()) : null;
            if (data == null) {
                return this.getDefaultFirst(list);
            }
            ValueParser<V> parser = this.parser();
            if (parser == null) {
                return this.getDefaultFirst(list);
            }
            int i = 0;
            for (Object dataVal : data) {
                if (dataVal == null) continue;
                try {
                    list.add(this.withValidated(parser.parse(this.holder(), this.paramType(), dataVal)));
                }
                catch (Exception e) {
                    this.throwing(this.path + "[" + i + "]", e);
                }
            }
        }
        catch (Exception ex) {
            this.throwing(ex);
        }
        return this.updateCache(list);
    }

    @Override
    public void set(@Nullable List<V> list) {
        this.updateCache(list);
        if (list == null) {
            this.setData(null);
            return;
        }
        ValueSerializer<V> serializer = this.serializer();
        if (serializer == null) {
            return;
        }
        ArrayList<Object> data = new ArrayList<Object>();
        for (V val : list) {
            if (val == null) continue;
            try {
                data.add(serializer.serialize(this.holder(), this.paramType(), this.withValidated(val)));
            }
            catch (Exception ex) {
                this.throwing(ex);
            }
        }
        this.setData(data);
    }

    @Override
    public V get(int index) {
        return (V)((List)this.resolve()).get(index);
    }

    @NotNull
    public List<V> copy() {
        return new ArrayList((Collection)this.resolve());
    }

    @NotNull
    public <T> T handle(Function<List<V>, T> function) {
        List list = (List)this.resolve();
        T result = function.apply(list);
        this.set(list);
        return result;
    }

    @NotNull
    public ConfiguredList<V> modify(Consumer<List<V>> consumer) {
        List list = (List)this.resolve();
        consumer.accept(list);
        this.set(list);
        return this;
    }

    @Override
    public V set(int index, V element) {
        return (V)this.handle(list -> list.set(index, element));
    }

    @Override
    public int size() {
        return ((List)this.resolve()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((List)this.resolve()).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((List)this.resolve()).contains(o);
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return ((List)this.resolve()).iterator();
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return ((List)this.resolve()).toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull T[] a) {
        return ((List)this.resolve()).toArray(a);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return new HashSet((Collection)this.resolve()).containsAll(c);
    }

    @Override
    public boolean add(V v) {
        this.handle(list -> list.add(v));
        return true;
    }

    @Override
    public void add(int index, V element) {
        this.modify(list -> list.add(index, element));
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> c) {
        return this.handle(list -> list.addAll(c));
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends V> c) {
        return this.handle(list -> list.addAll(index, c));
    }

    @Override
    public boolean remove(Object o) {
        return this.handle(list -> list.remove(o));
    }

    @Override
    public V remove(int index) {
        return (V)this.handle(list -> list.remove(index));
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.handle(list -> list.removeAll(c));
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.handle(list -> list.retainAll(c));
    }

    @Override
    public void clear() {
        this.modify(List::clear);
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.resolve()).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.resolve()).lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator() {
        return ((List)this.resolve()).listIterator();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator(int index) {
        return ((List)this.resolve()).listIterator(index);
    }

    @Override
    @NotNull
    public List<V> subList(int fromIndex, int toIndex) {
        return ((List)this.resolve()).subList(fromIndex, toIndex);
    }
}

