/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.standard;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueParser;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueSerializer;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.map.ConfigMapCreator;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import com.artformgames.plugin.residencelist.lib.configuration.value.impl.CachedConfigValue;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ConfiguredMap<K, V>
extends CachedConfigValue<Map<K, V>, V>
implements Map<K, V> {
    @NotNull
    protected final Supplier<? extends Map<K, V>> constructor;
    @NotNull
    protected final ValueAdapter<K> keyAdapter;
    @NotNull
    protected final ValueAdapter<V> valueAdapter;

    public static <V> ConfigMapCreator<String, V> builderOf(@NotNull Class<V> valueType) {
        return ConfiguredMap.builderOf(String.class, valueType);
    }

    public static <K, V> ConfigMapCreator<K, V> builderOf(@NotNull ValueType<K> keyType, @NotNull ValueType<V> valueType) {
        return new ConfigMapCreator<K, V>(keyType, valueType);
    }

    public static <K, V> ConfigMapCreator<K, V> builderOf(@NotNull Class<K> keyType, @NotNull Class<V> valueType) {
        return new ConfigMapCreator<K, V>(ValueType.of(keyType), ValueType.of(valueType));
    }

    public static <K, V> ConfiguredMap<K, V> of(@NotNull Supplier<? extends Map<K, V>> constructor, @NotNull ValueAdapter<K> keyAdapter, @NotNull ValueAdapter<V> valueAdapter) {
        return new ConfiguredMap(new ValueManifest(new ValueType<Map<K, V>>(){}, constructor::get), constructor, keyAdapter, valueAdapter);
    }

    public ConfiguredMap(@NotNull ValueManifest<Map<K, V>, V> manifest, @NotNull Supplier<? extends Map<K, V>> constructor, @NotNull ValueAdapter<K> keyAdapter, @NotNull ValueAdapter<V> valueAdapter) {
        super(manifest);
        this.constructor = constructor;
        this.keyAdapter = keyAdapter;
        this.valueAdapter = valueAdapter;
    }

    @NotNull
    public ValueAdapter<K> keyAdapter() {
        return this.keyAdapter;
    }

    @NotNull
    public ValueType<K> keyType() {
        return this.keyAdapter().type();
    }

    @NotNull
    public ValueAdapter<V> valueAdapter() {
        return this.valueAdapter;
    }

    @NotNull
    public ValueType<V> valueType() {
        return this.valueAdapter().type();
    }

    private Map<K, V> createMap() {
        return this.constructor.get();
    }

    @Override
    @NotNull
    public Map<K, V> get() {
        if (!this.cacheExpired()) {
            return this.getCachedOrDefault(this.createMap());
        }
        Map<K, V> map = this.createMap();
        try {
            ConfigureSection section = this.config().getSection(this.path());
            if (section == null) {
                return this.getDefaultFirst(map);
            }
            Set<String> keys = section.getKeys(false);
            if (keys.isEmpty()) {
                return this.getDefaultFirst(map);
            }
            ValueParser<K> keyParser = this.parserFor(this.keyAdapter);
            if (keyParser == null) {
                return this.getDefaultFirst(map);
            }
            ValueParser<V> valueParser = this.parserFor(this.valueAdapter);
            if (valueParser == null) {
                return this.getDefaultFirst(map);
            }
            for (String dataKey : keys) {
                Object dataVal = section.get(dataKey);
                if (dataVal == null) continue;
                try {
                    K key = keyParser.parse(this.holder(), this.keyType(), dataKey);
                    V value = valueParser.parse(this.holder(), this.valueType(), dataVal);
                    map.put(key, this.withValidated(value));
                }
                catch (Exception e) {
                    this.throwing(this.path + "." + dataKey, e);
                }
            }
        }
        catch (Exception ex) {
            this.throwing(ex);
        }
        return this.updateCache(map);
    }

    @Override
    public V get(Object key) {
        return this.get().get(key);
    }

    public V getNotNull(@Nullable K key) {
        return Objects.requireNonNull(this.get(key));
    }

    @Override
    public void set(@Nullable Map<K, V> value) {
        this.updateCache(value);
        if (value == null) {
            this.setData(null);
            return;
        }
        try {
            ValueSerializer<K> keySerializer = this.serializerFor(this.keyAdapter);
            if (keySerializer == null) {
                return;
            }
            ValueSerializer<V> valueSerializer = this.serializerFor(this.valueAdapter);
            if (valueSerializer == null) {
                return;
            }
            LinkedHashMap<Object, Object> data = new LinkedHashMap<Object, Object>();
            for (Map.Entry<K, V> entry : value.entrySet()) {
                try {
                    data.put(keySerializer.serialize(this.holder(), this.keyType(), entry.getKey()), valueSerializer.serialize(this.holder(), this.valueType(), this.withValidated(entry.getValue())));
                }
                catch (Exception e) {
                    this.throwing(this.path + "." + entry.getKey(), e);
                }
            }
            this.setData(data);
        }
        catch (Exception ex) {
            this.throwing(ex);
        }
    }

    @NotNull
    public <T> T handle(Function<Map<K, V>, T> function) {
        Object m = this.get();
        T result = function.apply((Map<K, V>)m);
        this.set((Map<K, V>)m);
        return result;
    }

    @NotNull
    public ConfiguredMap<K, V> modify(Consumer<Map<K, V>> consumer) {
        Object m = this.get();
        consumer.accept((Map<K, V>)m);
        this.set((Map<K, V>)m);
        return this;
    }

    @Override
    public int size() {
        return this.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.get().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.get().containsValue(value);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        return (V)this.handle(m -> m.put(key, value));
    }

    @Override
    public V remove(Object key) {
        return (V)this.handle(m -> m.remove(key));
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.modify(map -> map.putAll(m));
    }

    @Override
    public void clear() {
        this.modify(Map::clear);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.get().keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.get().values();
    }

    @Override
    @NotNull
    public @Unmodifiable Set<Map.Entry<K, V>> entrySet() {
        return this.get().entrySet();
    }
}

