/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.standard;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueParser;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueSerializer;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.value.ConfigValueBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.builder.value.SourceValueBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import com.artformgames.plugin.residencelist.lib.configuration.value.impl.CachedConfigValue;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguredValue<V>
extends CachedConfigValue<V, V> {
    @NotNull
    protected final ValueAdapter<V> adapter;

    public static <V> ConfigValueBuilder<V> builderOf(@NotNull Class<V> type) {
        return new ConfigValueBuilder<V>(ValueType.of(type));
    }

    public static <V> ConfigValueBuilder<V> builderOf(@NotNull ValueType<V> type) {
        return new ConfigValueBuilder<V>(type);
    }

    public static <V> SourceValueBuilder<V, V> with(@NotNull Class<V> registeredType) {
        return ConfiguredValue.with(ValueType.of(registeredType));
    }

    public static <V> SourceValueBuilder<V, V> with(@NotNull ValueType<V> registeredType) {
        return new ConfigValueBuilder<V>(registeredType).from(registeredType);
    }

    public static <V> ConfiguredValue<V> of(@NotNull V defaults) {
        return ConfiguredValue.of(ValueType.of(defaults), () -> defaults);
    }

    public static <V> ConfiguredValue<V> of(@NotNull Class<V> type) {
        return ConfiguredValue.of(ValueType.of(type), () -> null);
    }

    public static <V> ConfiguredValue<V> of(@NotNull Class<V> type, @NotNull V defaults) {
        return ConfiguredValue.of(ValueType.of(type), () -> defaults);
    }

    public static <V> ConfiguredValue<V> of(@NotNull Class<V> type, @NotNull Supplier<@Nullable V> defaultSupplier) {
        return ConfiguredValue.of(ValueType.of(type), defaultSupplier);
    }

    public static <V> ConfiguredValue<V> of(@NotNull ValueType<V> type) {
        return ConfiguredValue.of(type, () -> null);
    }

    public static <V> ConfiguredValue<V> of(@NotNull ValueType<V> type, @NotNull Supplier<@Nullable V> defaultSupplier) {
        return ConfiguredValue.of(new ValueManifest(type, defaultSupplier), (provider, t, data) -> provider.deserialize(type, data), (provider, t, value) -> provider.serialize(value));
    }

    public static <V> ConfiguredValue<V> of(@NotNull ValueManifest<V, V> manifest, @Nullable ValueParser<V> parser, @Nullable ValueSerializer<V> serializer) {
        ValueAdapter<V> adapter = new ValueAdapter<V>(manifest.type());
        adapter.parser(parser);
        adapter.serializer(serializer);
        return ConfiguredValue.of(manifest, adapter);
    }

    public static <V> ConfiguredValue<V> of(@NotNull ValueManifest<V, V> manifest, @NotNull ValueAdapter<V> adapter) {
        return new ConfiguredValue<V>(manifest, adapter);
    }

    public ConfiguredValue(@NotNull ValueManifest<V, V> manifest, @NotNull ValueAdapter<V> adapter) {
        super(manifest);
        this.adapter = adapter;
    }

    @NotNull
    public ValueAdapter<V> adapter() {
        return this.adapter;
    }

    @Nullable
    public ValueParser<V> parser() {
        return this.parserFor(this.adapter());
    }

    @Nullable
    public ValueSerializer<V> serializer() {
        return this.serializerFor(this.adapter());
    }

    @Override
    public V get() {
        if (!this.cacheExpired()) {
            return (V)this.getCachedOrDefault();
        }
        try {
            Object data = this.getData();
            if (data == null) {
                return (V)this.defaults();
            }
            ValueParser<V> parser = this.parser();
            if (parser == null) {
                return (V)this.defaults();
            }
            V parsed = parser.parse(this.holder(), this.type(), data);
            return this.updateCache(this.withValidated(parsed));
        }
        catch (Exception e) {
            this.throwing(e);
            return (V)this.defaults();
        }
    }

    @Override
    public void set(@Nullable V value) {
        this.updateCache(value);
        if (value == null) {
            this.setData(null);
            return;
        }
        try {
            ValueSerializer<V> serializer = this.serializer();
            if (serializer == null) {
                return;
            }
            this.setData(serializer.serialize(this.holder(), this.type(), this.withValidated(value)));
        }
        catch (Exception e) {
            this.throwing(e);
        }
    }
}

