/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.data;

import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextContents {
    @NotNull
    protected final List<String> lines;
    @NotNull
    protected final Map<String, List<String>> optional;

    public static Builder builder() {
        return new Builder();
    }

    public static TextContents of(@NotNull List<String> lines, @NotNull Map<String, List<String>> optional) {
        return new TextContents(lines, optional);
    }

    public TextContents(@NotNull List<String> lines, @NotNull Map<String, List<String>> optional) {
        this.lines = lines;
        this.optional = optional;
    }

    public boolean isEmpty() {
        return this.lines.isEmpty() || this.lines.stream().allMatch(String::isEmpty);
    }

    @NotNull
    public List<String> lines() {
        return this.lines;
    }

    @NotNull
    public Map<String, List<String>> optionalLines() {
        return this.optional;
    }

    @Nullable
    public Object serialize() {
        if (this.optional.isEmpty()) {
            if (this.lines.isEmpty()) {
                return null;
            }
            if (this.lines.size() == 1) {
                return this.lines.get(0);
            }
            return this.lines;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("contents", this.lines);
        map.put("optional", this.optional);
        return map;
    }

    @Nullable
    public static TextContents deserialize(@NotNull Object data) {
        Builder builder = TextContents.builder();
        if (data instanceof String) {
            return builder.set((String)data).build();
        }
        if (data instanceof List) {
            ((List)data).stream().map(Object::toString).forEach(xva$0 -> builder.add((String)xva$0));
            return builder.build();
        }
        if (data instanceof ConfigureSection) {
            ConfigureSection section = (ConfigureSection)data;
            builder.set(section.getStringList("contents"));
            ConfigureSection optionalSection = section.getSection("optional");
            if (optionalSection != null) {
                for (String key : optionalSection.getKeys(false)) {
                    builder.optional(key, optionalSection.getStringList(key));
                }
            }
            return builder.build();
        }
        return null;
    }

    public static class Builder {
        protected List<String> lines = new ArrayList<String>();
        protected Map<String, List<String>> optional = new HashMap<String, List<String>>();

        public Builder add(String ... lines) {
            this.lines.addAll(Arrays.asList(lines));
            return this;
        }

        public Builder add(@NotNull Iterable<String> lines) {
            lines.forEach(this.lines::add);
            return this;
        }

        public Builder set(String ... lines) {
            this.lines = Arrays.asList(lines);
            return this;
        }

        public Builder set(@NotNull Iterable<String> lines) {
            this.lines = new ArrayList<String>();
            lines.forEach(this.lines::add);
            return this;
        }

        public Builder optional(@NotNull String key, String ... lines) {
            this.optional.put(key, Arrays.asList(lines));
            return this;
        }

        public Builder optional(@NotNull String key, @NotNull Iterable<String> lines) {
            ArrayList list = new ArrayList();
            lines.forEach(list::add);
            this.optional.put(key, list);
            return this;
        }

        public TextContents build() {
            return TextContents.of(this.lines, this.optional);
        }
    }
}

