/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.function;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.data.TextContents;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.common.AppendLineInserter;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.common.OptionalLineInserter;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.common.ParamReplacer;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.inserter.ContentInserter;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.inserter.Insertable;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.replacer.ContentReplacer;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.replacer.Replaceable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContentHandler<RECEIVER, SELF extends ContentHandler<RECEIVER, SELF>>
implements Replaceable<RECEIVER, SELF>,
Insertable<RECEIVER, SELF> {
    protected BiFunction<RECEIVER, String, String> parser = (receiver, value) -> value;
    protected String lineSeparator = System.lineSeparator();
    @NotNull
    protected ParamReplacer<RECEIVER> paramReplacer = ParamReplacer.defaults();
    @NotNull
    protected String[] params;
    @NotNull
    protected List<ContentReplacer<RECEIVER>> replacers = new ArrayList<ContentReplacer<RECEIVER>>();
    @NotNull
    protected List<ContentInserter<RECEIVER>> inserters = new ArrayList<ContentInserter<RECEIVER>>();
    protected final @NotNull Map<String, @Nullable Function<RECEIVER, List<String>>> insertion = new HashMap<String, Function<RECEIVER, List<String>>>();
    protected boolean disableInsertion = false;

    public ContentHandler() {
        this.inserters.add(new AppendLineInserter(0));
        this.inserters.add(new OptionalLineInserter(0));
    }

    public abstract SELF self();

    public SELF disableInsertion() {
        this.disableInsertion = true;
        return this.self();
    }

    public SELF enableInsertion() {
        this.disableInsertion = false;
        return this.self();
    }

    @Override
    public boolean noneInsertion() {
        return this.insertion.isEmpty();
    }

    public SELF lineSeparator(@NotNull String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this.self();
    }

    public SELF placeholders(@NotNull Map<String, Object> placeholders) {
        this.paramReplacer.set(placeholders);
        return this.self();
    }

    public SELF placeholders(@NotNull Consumer<Map<String, Object>> consumer) {
        consumer.accept(this.paramReplacer.placeholders());
        return this.self();
    }

    public SELF placeholders(Object ... values) {
        this.paramReplacer.putAll(this.params, values);
        return this.self();
    }

    public SELF placeholder(@NotNull String key, @Nullable Object value) {
        this.paramReplacer.put(key, value);
        return this.self();
    }

    public SELF params(String ... params) {
        this.params = params;
        return this.self();
    }

    @Override
    public List<ContentReplacer<RECEIVER>> replacers() {
        return this.replacers;
    }

    @Override
    public SELF replacer(@NotNull ContentReplacer<RECEIVER> replacer) {
        this.replacers.add(replacer);
        this.replacers.sort(ContentReplacer::compareTo);
        return this.self();
    }

    public SELF paramReplacer(@NotNull ParamReplacer<RECEIVER> paramReplacer) {
        this.paramReplacer = paramReplacer;
        return this.self();
    }

    @Override
    public List<ContentInserter<RECEIVER>> inserters() {
        return this.inserters;
    }

    @Override
    public SELF inserter(@NotNull ContentInserter<RECEIVER> inserter) {
        this.inserters.add(inserter);
        this.inserters.sort(ContentInserter::compareTo);
        return this.self();
    }

    @Override
    public SELF insert(@NotNull String id, @Nullable Function<RECEIVER, List<String>> supplier) {
        this.insertion.put(id, supplier);
        return this.self();
    }

    @Override
    public boolean inserting(@NotNull String id) {
        return this.insertion.keySet().stream().anyMatch(key -> key.equalsIgnoreCase(id));
    }

    @Override
    @Nullable
    public List<String> getInsertion(@NotNull String id, @Nullable RECEIVER receiver) {
        Function<RECEIVER, List<String>> function = this.insertion.get(id);
        if (function == null) {
            return null;
        }
        return function.apply(receiver);
    }

    @Override
    public SELF removeInsert(@NotNull String id) {
        this.insertion.remove(id);
        return this.self();
    }

    public SELF parser(@NotNull BiFunction<RECEIVER, String, String> parser) {
        this.parser = parser;
        return this.self();
    }

    @Nullable
    protected String parse(@Nullable RECEIVER receiver, @NotNull String text) {
        text = this.applyReplacements(receiver, text);
        text = this.paramReplacer.replace(text, receiver);
        return this.parser.apply(receiver, text);
    }

    public void handle(@NotNull TextContents contents, @Nullable RECEIVER receiver, @NotNull Consumer<String> lineConsumer) {
        if (contents.isEmpty()) {
            return;
        }
        if (this.disableInsertion || this.noneInsertion()) {
            contents.lines().forEach(line -> lineConsumer.accept(this.parse(receiver, (String)line)));
            return;
        }
        for (Map.Entry<String, Function<RECEIVER, List<String>>> entry : this.insertion.entrySet()) {
            List<String> lines;
            if (entry.getValue() != null || (lines = contents.optionalLines().get(entry.getKey())) == null) continue;
            entry.setValue(r -> lines);
        }
        block1: for (String line2 : contents.lines()) {
            for (ContentInserter<RECEIVER> inserter : this.inserters) {
                List<String> inserted = inserter.handle(receiver, line2, this);
                if (inserted == null) continue;
                inserted.forEach(l -> lineConsumer.accept(this.parse(receiver, (String)l)));
                continue block1;
            }
            lineConsumer.accept(this.parse(receiver, line2));
        }
    }

    public static String setPlaceholders(@NotNull String messages, @NotNull Map<String, Object> placeholders) {
        if (messages.isEmpty()) {
            return messages;
        }
        String parsed = messages;
        for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
            parsed = parsed.replace(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
        }
        return parsed;
    }

    public static Map<String, Object> buildParams(@NotNull UnaryOperator<String> paramBuilder, @Nullable String[] params, @Nullable Object[] values) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (params == null || params.length == 0) {
            return map;
        }
        for (int i = 0; i < params.length; ++i) {
            map.put((String)paramBuilder.apply(params[i]), values != null && values.length > i ? values[i] : "?");
        }
        return map;
    }
}

