/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.function;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.data.TextContents;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.ContentHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextParser<RECEIVER, SELF extends TextParser<RECEIVER, SELF>>
extends ContentHandler<RECEIVER, SELF> {
    public abstract TextContents texts();

    public List<String> parse(@Nullable RECEIVER receiver) {
        ArrayList<String> result = new ArrayList<String>();
        this.handle(receiver, result::add);
        return result;
    }

    public <V> List<V> parse(@Nullable RECEIVER receiver, @NotNull BiFunction<RECEIVER, String, V> compiler) {
        ArrayList result = new ArrayList();
        this.handle(receiver, s -> result.add(compiler.apply(receiver, (String)s)));
        return result;
    }

    @Nullable
    public String parseLine(@Nullable RECEIVER receiver) {
        if (this.texts().isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        this.handle(receiver, s -> builder.append((String)s).append(this.lineSeparator));
        if (builder.length() > 0) {
            builder.delete(builder.length() - this.lineSeparator.length(), builder.length());
        }
        return builder.toString();
    }

    @Nullable
    public <V> V parseLine(@Nullable RECEIVER receiver, @NotNull BiFunction<RECEIVER, String, V> compiler) {
        return Optional.ofNullable(this.parseLine(receiver)).map(s -> compiler.apply(receiver, (String)s)).orElse(null);
    }

    public void handle(@Nullable RECEIVER receiver, @NotNull Consumer<String> lineConsumer) {
        this.handle(this.texts(), receiver, lineConsumer);
    }
}

