/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.function.common;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.inserter.ContentInserter;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.inserter.Insertable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppendLineInserter<RECEIVER>
extends ContentInserter<RECEIVER> {
    @NotNull
    public static final Pattern APPEND_PATTERN = Pattern.compile("^(?:\\{(?<prefix>.*)})?#(?<id>.*)#(?:\\{(?<above>-?\\d+)(?:,(?<down>-?\\d+))?})?$");

    public AppendLineInserter(int priority) {
        super(priority, APPEND_PATTERN);
    }

    @Override
    @Nullable
    protected String extractID(@NotNull Matcher matcher) {
        return matcher.group("id");
    }

    @Override
    @NotNull
    protected List<String> get(@Nullable RECEIVER receiver, @NotNull Matcher matcher, @NotNull Insertable<RECEIVER, ?> insertion) {
        String id = this.extractID(matcher);
        List<String> values = insertion.getInsertion(id, receiver);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        String prefix = Optional.ofNullable(matcher.group("prefix")).orElse("");
        int offsetAbove = Optional.ofNullable(matcher.group("above")).map(Integer::parseInt).orElse(0);
        int offsetDown = Optional.ofNullable(matcher.group("down")).map(Integer::parseInt).orElse(offsetAbove);
        ArrayList<String> contents = new ArrayList<String>();
        IntStream.range(0, Math.max(0, offsetAbove)).mapToObj(i -> "").forEach(contents::add);
        values.stream().map(value -> prefix + value).forEach(contents::add);
        IntStream.range(0, Math.max(0, offsetDown)).mapToObj(i -> "").forEach(contents::add);
        return contents;
    }
}

