/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.function.common;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.inserter.ContentInserter;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.inserter.Insertable;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalLineInserter<RECEIVER>
extends ContentInserter<RECEIVER> {
    @NotNull
    public static final Pattern OPTIONAL_PATTERN = Pattern.compile("^\\?\\[(?<id>.+)](?<content>.*)$");

    public OptionalLineInserter(int priority) {
        super(priority, OPTIONAL_PATTERN);
    }

    @Override
    @Nullable
    protected String extractID(@NotNull Matcher matcher) {
        return matcher.group("id");
    }

    @Override
    @NotNull
    protected List<String> get(@Nullable RECEIVER receiver, @NotNull Matcher matcher, @NotNull Insertable<RECEIVER, ?> insertion) {
        String content = matcher.group("content");
        if (content == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(content);
    }
}

