/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.function.common;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.replacer.ContentReplacer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParamReplacer<RECEIVER>
extends ContentReplacer<RECEIVER> {
    @NotNull
    public static final Pattern DEFAULT_PARAM_PATTERN = Pattern.compile("%\\((?<id>[^)]+)\\)");
    protected final @NotNull Function<Matcher, @Nullable String> extractor;
    @NotNull
    protected Map<String, Object> placeholders = new HashMap<String, Object>();

    public static <R> ParamReplacer<R> defaults() {
        return ParamReplacer.create(DEFAULT_PARAM_PATTERN, m -> m.group("id"));
    }

    public static <R> ParamReplacer<R> create(@NotNull Pattern pattern, @NotNull Function<Matcher, String> extractor) {
        return new ParamReplacer(0, pattern, extractor);
    }

    public ParamReplacer(int priority, @NotNull Pattern pattern, @NotNull Function<Matcher, String> extractor) {
        super(priority, pattern);
        this.extractor = extractor;
    }

    @NotNull
    public Map<String, Object> placeholders() {
        return this.placeholders;
    }

    @Override
    @Nullable
    protected String get(@NotNull RECEIVER receiver, @NotNull Matcher matcher) {
        @Nullable String id = this.extractor.apply(matcher);
        if (id == null) {
            return null;
        }
        Object value = this.placeholders.get(id);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void set(@NotNull Map<String, Object> placeholders) {
        this.placeholders = placeholders;
    }

    public void put(@NotNull String id, @Nullable Object value) {
        this.placeholders.put(id, value);
    }

    public void remove(@NotNull String id) {
        this.placeholders.remove(id);
    }

    public void putAll(@NotNull Map<String, Object> placeholders) {
        this.placeholders.putAll(placeholders);
    }

    public void putAll(@NotNull String[] params, @NotNull Object[] values) {
        for (int i = 0; i < params.length; ++i) {
            this.placeholders.put(params[i], values != null && values.length > i ? values[i] : "?");
        }
    }

    public void clear() {
        this.placeholders.clear();
    }
}

