/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.function.inserter;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.inserter.Insertable;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContentInserter<RECEIVER>
implements Comparable<ContentInserter<RECEIVER>> {
    protected final int priority;
    @NotNull
    protected Pattern pattern;

    public ContentInserter(int priority, @NotNull Pattern pattern) {
        this.priority = priority;
        this.pattern = pattern;
    }

    public int priority() {
        return this.priority;
    }

    public void setPattern(@NotNull Pattern pattern) {
        this.pattern = pattern;
    }

    @NotNull
    public Matcher matcher(@NotNull String text) {
        return this.pattern.matcher(text);
    }

    @Nullable
    protected abstract String extractID(@NotNull Matcher var1);

    @NotNull
    protected abstract List<String> get(@Nullable RECEIVER var1, @NotNull Matcher var2, @NotNull Insertable<RECEIVER, ?> var3);

    @Nullable
    public List<String> handle(@Nullable RECEIVER receiver, @NotNull String line, @NotNull Insertable<RECEIVER, ?> insertions) {
        Matcher matcher = this.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        if (!insertions.inserting(this.extractID(matcher))) {
            return Collections.emptyList();
        }
        return this.get(receiver, matcher, insertions);
    }

    @Override
    public int compareTo(@NotNull ContentInserter<RECEIVER> o) {
        return Integer.compare(o.priority, this.priority);
    }
}

