/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.function.replacer;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContentReplacer<RECEIVER>
implements Comparable<ContentReplacer<RECEIVER>> {
    protected final int priority;
    @NotNull
    protected Pattern pattern;

    public static <R> Builder<R> match(@NotNull Pattern pattern) {
        return new Builder(pattern);
    }

    public static <R> Builder<R> match(@NotNull String pattern) {
        return ContentReplacer.match(Pattern.compile(pattern));
    }

    public static <R> Builder<R> replace(@NotNull String text) {
        return ContentReplacer.match(Pattern.quote(text));
    }

    public ContentReplacer(int priority, @NotNull Pattern pattern) {
        this.priority = priority;
        this.pattern = pattern;
    }

    public int priority() {
        return this.priority;
    }

    public void pattern(@NotNull Pattern pattern) {
        this.pattern = pattern;
    }

    @NotNull
    public Matcher matcher(@NotNull String text) {
        return this.pattern.matcher(text);
    }

    public String replace(@NotNull String text, @Nullable RECEIVER receiver) {
        Matcher matcher = this.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replaced = this.get(receiver, matcher);
            matcher.appendReplacement(sb, replaced == null ? "" : replaced);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Nullable
    protected abstract String get(@Nullable RECEIVER var1, @NotNull Matcher var2);

    @Override
    public int compareTo(@NotNull ContentReplacer<RECEIVER> o) {
        return Integer.compare(o.priority, this.priority);
    }

    @FunctionalInterface
    public static interface Constructor<R>
    extends Function<Builder<R>, ContentReplacer<R>> {
    }

    public static class Builder<R> {
        @NotNull
        protected final Pattern pattern;
        protected int priority = 0;

        public Builder(@NotNull Pattern pattern) {
            this.pattern = pattern;
        }

        @NotNull
        public Builder<R> priority(int priority) {
            this.priority = priority;
            return this;
        }

        @NotNull
        public ContentReplacer<R> to(final BiFunction<@Nullable R, @NotNull Matcher, @Nullable String> supplier) {
            return new ContentReplacer<R>(this.priority, this.pattern){

                @Override
                @Nullable
                protected String get(@NotNull R receiver, @NotNull Matcher matcher) {
                    return (String)supplier.apply(receiver, matcher);
                }
            };
        }

        @NotNull
        public ContentReplacer<R> to(Function<@Nullable R, @Nullable String> supplier) {
            return this.to((R receiver, Matcher matchedParam) -> (String)supplier.apply(receiver));
        }

        @NotNull
        public ContentReplacer<R> to(Supplier<@Nullable String> supplier) {
            return this.to((R receiver, Matcher matchedParam) -> (String)supplier.get());
        }

        @NotNull
        public ContentReplacer<R> to(@NotNull String content) {
            return this.to(() -> content);
        }
    }
}

