/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.configuration.value.text.function.replacer;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.replacer.ContentReplacer;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Replaceable<RECEIVER, SELF> {
    public List<ContentReplacer<RECEIVER>> replacers();

    default public String applyReplacements(@Nullable RECEIVER receiver, @NotNull String text) {
        for (ContentReplacer<RECEIVER> replacer : this.replacers()) {
            text = replacer.replace(text, receiver);
        }
        return text;
    }

    public SELF replacer(@NotNull ContentReplacer<RECEIVER> var1);

    default public SELF replacer(@NotNull Pattern pattern, @NotNull ContentReplacer.Constructor<RECEIVER> constructor) {
        ContentReplacer.Builder builder = ContentReplacer.match(pattern);
        return this.replacer((ContentReplacer)constructor.apply(builder));
    }

    default public SELF replace(@NotNull Pattern pattern, @NotNull @NotNull BiFunction<@Nullable RECEIVER, @NotNull Matcher, @Nullable String> supplier) {
        return this.replacer(pattern, builder -> builder.to(supplier));
    }

    default public SELF replace(@NotNull Pattern pattern, @NotNull Function<@Nullable RECEIVER, @Nullable String> supplier) {
        return this.replacer(pattern, builder -> builder.to(supplier));
    }

    default public SELF replace(@NotNull Pattern pattern, @NotNull Supplier<@Nullable String> supplier) {
        return this.replacer(pattern, builder -> builder.to(supplier));
    }

    default public SELF replace(@NotNull Pattern pattern, @NotNull String replacement) {
        return this.replacer(pattern, builder -> builder.to(replacement));
    }

    default public SELF replace(@NotNull String text, @NotNull String replacement) {
        return this.replacer(Pattern.compile(Pattern.quote(text)), builder -> builder.to(replacement));
    }

    default public SELF replace(@NotNull String text, @NotNull Supplier<@Nullable String> supplier) {
        return this.replacer(Pattern.compile(Pattern.quote(text)), builder -> builder.to(supplier));
    }

    default public SELF replace(@NotNull String text, @NotNull Function<@Nullable RECEIVER, @Nullable String> supplier) {
        return this.replacer(Pattern.compile(Pattern.quote(text)), builder -> builder.to(supplier));
    }
}

