/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin;

import com.artformgames.plugin.residencelist.lib.easyplugin.i18n.EasyPluginMessageProvider;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.JarResourceUtils;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.SchedulerUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EasyPlugin
extends JavaPlugin {
    @NotNull
    protected EasyPluginMessageProvider messageProvider;
    protected SchedulerUtils scheduler;
    protected boolean initialized = false;

    public EasyPlugin() {
        this(EasyPluginMessageProvider.ZH_CN);
    }

    public EasyPlugin(@NotNull EasyPluginMessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }

    protected EasyPlugin(JavaPluginLoader loader, PluginDescriptionFile descriptionFile, File dataFolder, File file) {
        this(EasyPluginMessageProvider.ZH_CN, loader, descriptionFile, dataFolder, file);
    }

    protected EasyPlugin(@NotNull EasyPluginMessageProvider messageProvider, JavaPluginLoader loader, PluginDescriptionFile descriptionFile, File dataFolder, File file) {
        super(loader, descriptionFile, dataFolder, file);
        this.messageProvider = messageProvider;
    }

    public final void onLoad() {
        this.scheduler = new SchedulerUtils(this);
        if (!this.hasOverride("load")) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.log(this.messageProvider.loading((Plugin)this));
        this.load();
        this.log(this.messageProvider.loaded((Plugin)this, startTime));
    }

    public final void onEnable() {
        this.outputInfo();
        this.log(this.messageProvider.enabling((Plugin)this));
        long startTime = System.currentTimeMillis();
        this.initialized = this.initialize();
        if (!this.initialized) {
            this.setEnabled(false);
            this.log(this.messageProvider.enableFailure((Plugin)this, startTime));
            return;
        }
        this.log(this.messageProvider.enableSuccess((Plugin)this, startTime));
    }

    public final void onDisable() {
        if (!this.hasOverride("shutdown") || !this.initialized) {
            return;
        }
        this.outputInfo();
        this.log(this.messageProvider.disabling((Plugin)this));
        long startTime = System.currentTimeMillis();
        this.shutdown();
        this.log(this.messageProvider.disabled((Plugin)this, startTime));
    }

    protected void load() {
    }

    protected abstract boolean initialize();

    protected void shutdown() {
    }

    public void outputInfo() {
        Optional.ofNullable(JarResourceUtils.readResource(this.getResource("PLUGIN_INFO"))).ifPresent(this::log);
    }

    public boolean isDebugging() {
        return false;
    }

    public SchedulerUtils getScheduler() {
        return this.scheduler;
    }

    public void registerListener(Listener ... listeners) {
        Arrays.stream(listeners).forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, (Plugin)this));
    }

    public void registerCommand(String commandName, @NotNull CommandExecutor executor) {
        this.registerCommand(commandName, executor, executor instanceof TabCompleter ? (TabCompleter)executor : null);
    }

    public void registerCommand(String commandName, @NotNull CommandExecutor executor, @Nullable TabCompleter tabCompleter) {
        PluginCommand command = Bukkit.getPluginCommand((String)commandName);
        if (command == null) {
            return;
        }
        command.setExecutor(executor);
        if (tabCompleter != null) {
            command.setTabCompleter(tabCompleter);
        }
    }

    public void print(@Nullable String prefix, String ... messages) {
        this.messageProvider.print((Plugin)this, prefix, messages);
    }

    public void log(String ... messages) {
        this.print(null, messages);
    }

    public void error(String ... messages) {
        this.print("&c[ERROR] &r", messages);
    }

    public void debug(String ... messages) {
        if (this.isDebugging()) {
            this.print("&8[DEBUG] &r", messages);
        }
    }

    @NotNull
    public <T> CompletableFuture<T> supplySync(@NotNull Supplier<T> action) {
        CompletableFuture future = new CompletableFuture();
        this.getScheduler().run(() -> future.complete(action.get()));
        return future;
    }

    @NotNull
    public <T> CompletableFuture<T> supplyAsync(@NotNull Supplier<T> action) {
        CompletableFuture future = new CompletableFuture();
        this.getScheduler().runAsync(() -> future.complete(action.get()));
        return future;
    }

    @NotNull
    public <T extends Event> CompletableFuture<T> callSync(T event) {
        return this.supplySync(() -> {
            Bukkit.getPluginManager().callEvent(event);
            return event;
        });
    }

    @NotNull
    public <T extends Event> CompletableFuture<T> callAsync(T event) {
        return this.supplyAsync(() -> {
            Bukkit.getPluginManager().callEvent(event);
            return event;
        });
    }

    protected void setMessageProvider(@NotNull EasyPluginMessageProvider provider) {
        this.messageProvider = provider;
    }

    private boolean hasOverride(String methodName) {
        HashMap methodMap = new HashMap();
        Arrays.stream(EasyPlugin.class.getDeclaredMethods()).filter(method -> method.getName().equals(methodName)).forEach(method -> Arrays.stream(((Object)((Object)this)).getClass().getDeclaredMethods()).filter(extend -> extend.getName().equals(methodName)).filter(extend -> extend.getReturnType().equals(method.getReturnType())).filter(extend -> extend.getParameterTypes().length == method.getParameterTypes().length).findFirst().ifPresent(extendMethod -> methodMap.put(method, extendMethod)));
        return !methodMap.isEmpty();
    }
}

